#ifndef YSQL_CONNECTION_H
#define YSQL_CONNECTION_H

#include <TSQLServer.h>
#include <YException.h>

using namespace yngn::YException;

namespace yngn {
    namespace sql {
        /**
         * Connection to the database.
         * In the furure it should became a pool of connections
         */
        class YSQLConnection {
        private:
          /**
           * The physics event that is created in this algorithm.
           */
          static TSQLServer        *sqlServer;
          static YSQLConnection    *sqlConnection;

          YSQLConnection(char*, char*, char*) throw (YSQLNotConnectedException);
        public: 
          static bool isConnected() { return (sqlServer == NULL); }
          static TSQLServer* getConnection(char*, char*, char*) throw (YSQLNotConnectedException);
          //static TSQLServer* getConnection(char*) throw (YSQLNotConnectedException);
          static TSQLServer* getConnection(void) throw (YSQLNotConnectedException);
        };
    }
}
#endif /* YSQL_CONNECTION_H */
