#include <log4cxx/logger.h>
#include <YSQLConnection.h>

using namespace log4cxx;
using namespace yngn;
using namespace yngn::sql;
using namespace yngn::YException;

    TSQLServer       *YSQLConnection::sqlServer      = 0;
    YSQLConnection   *YSQLConnection::sqlConnection  = 0;
    static LoggerPtr  logger         = Logger::getLogger(_T("yngn.sql.YSQLConnection"));

    /**
    * Private constructor for the YSQLConnection.
    * @param URL  Path to the database to be used.
    * @param user Name of the user to open the database connection.
    * @param psw  Password of the user to open the database connection.
    */
    YSQLConnection::YSQLConnection(char *URL, char *user, char *psw) throw (YSQLNotConnectedException) {
            YSQLConnection::sqlServer = TSQLServer::Connect(URL, user, psw);
            if (YSQLConnection::sqlServer == 0) throw YSQLNotConnectedException("Connection to database failed");
    }

    /**
    * Get an instance of YSQLConnection opening a connection to the database.
    * @param URL  Path to the database to be used.
    * @param user Name of the user to open the database connection.
    * @param psw  Password of the user to open the database connection.
    */
    TSQLServer* YSQLConnection::getConnection(char *URL, char *user, char *psw) throw (YSQLNotConnectedException) {
        if (YSQLConnection::sqlConnection == 0){
            YSQLConnection::sqlConnection = new YSQLConnection(URL, user, psw);
        } 
        return sqlServer;
    }

    /**
    * Get an instance of YSQLConnection opening a connection to the database.
    * @param URL      Path to the database to be used.
    * @param fileName Name of the file containing user/password to use for connection.
    
    TSQLServer* YSQLConnection::getConnection(char *URL, char *fileName) throw (YSQLNotConnectedException) {
        if (YSQLConnection::sqlConnection == 0){
            FILE * pFile;
            long lSize;
            char * buffer;  
            pFile = fopen (fileName, "r" );
            // obtain file size.
            fseek (pFile , 0 , SEEK_END);
            lSize = ftell (pFile);
            rewind (pFile);
            // allocate memory to contain the whole file.
            buffer = (char*) malloc (lSize);
            if (buffer == NULL) throw YSQLNotConnectedException("Connection file empty");
            // copy the file into the buffer.
            fread (buffer,1,lSize,pFile);
            // the whole file is loaded in the buffer. 
            // terminate
            fclose (pFile);
            YSQLConnection::sqlConnection = new YSQLConnection(URL, user, psw);
        } 
        return sqlServer;
    }
    */

    /**
    * Get an instance of YSQLConnection if a connection has already been opened connection to the database.
    */
    TSQLServer* YSQLConnection::getConnection(void) throw (YSQLNotConnectedException) {
        if (sqlConnection == NULL) throw YSQLNotConnectedException("Please connect to the database specifing the required parameters");
        return sqlServer;
    }

