#include <yodaUtility.h>
#include <TObject.h>
#include <TKey.h>

using namespace std;
/**
* digForFile(TTree& out, TSystemDirectory* tsd, string defin)
* author  Nagni
* version 1.0 - 1 September 2004
* 
* version 1.1 - 27 December 2004
* Checks on TFiles/TList existance
* 
* Retrieves and store into a TList according to the root directory and 
* a string contained into the filename.
*
* Parameters:
* 	out 	   - the output Tlist of files
* 	tsd 	   - the root directory
*       defin      - the filename substring
*
*/
void Utility::digForFiles(TList& out, TSystemDirectory *tsd, string defin){
  //char *initialDir = gSystem->pwd();
  TList       *lnk        = tsd->GetListOfFiles();
  if (lnk==0) return;	
  
  TSystemFile *file       = (TSystemFile*)lnk->First();
  
  if (file->IsZombie()) {
    //gSystem->cd(initialDir);
    return;
  }
  
  string      *fileDes    = new string(file->GetName());
  unsigned int loc = 0;
  
  while(file){
    fileDes = new string(file->GetName());
    if(!((fileDes->compare(".") == 0) || (fileDes->compare("..") == 0))){
      if (file->IsDirectory()){
	Utility::digForFiles(out, (TSystemDirectory*)file, defin);
      } else {
	loc = fileDes->find(defin.c_str(), 0);
	if (loc != string::npos){
	  out.AddLast((TObject*)file);
	  //                    printf("%s file name \n", file->GetName());
	} else {
	  
	}
      }
      
    }
    file = (TSystemFile*)lnk->After(file);
  }
  //gSystem->cd(initialDir);
  //printf("%d this is the actual size \n", out.GetSize());
}


/**
* makeAllFriend(TTree& out, TList* input)
* author  Nagni
* version 1.0 - 1 September 2004
* 
* version 1.1 - 27 December 2004
* Checks on TFiles/TList existance
* 
* Create a TTree promoting to friend all the files into the "input" parameter
* returning a TTree
*
* Parameters:
* 	input 	   - the input Tlist of files
* 	out 	   - the returned TTree
*
*/
void Utility::makeAllFriend(TTree& out, TList* input){
    TList           *keys;
    TKey            *key;
    TList           *resList;
    TTree           *tr;
    TFriendElement  *tfe;
    string          *base;
    string          *target;
    string          *className;
    unsigned int     loc;
    bool            cont = false;

    TSystemFile *tsf = (TSystemFile*)input->First();
    if (tsf->IsZombie()) return;

    while(tsf){
        base    = new string(tsf->GetTitle());
        base->append("/");
        base->append(tsf->GetName());
        //printf("baseAppend %s       \n", base->c_str());

        TFile *tf = new TFile(base->c_str());
	if (tf->IsZombie()) {
	  tsf = (TSystemFile*)input->After(tsf);
	  continue;
	}

        keys = tf->GetListOfKeys();
        key = (TKey*)keys->First();
        while(key){
            className = new string(key->GetClassName());
            loc = className->find("Tree", 0);
	    //            printf("%s className \n", className->c_str());
            if(loc != string::npos){
            tr = (TTree*)key->ReadObj();
            if (tr->GetEntries() > 0){
                if(cont){
                    tr = (TTree*)key->ReadObj();
		    //                    printf("%s TreeName \n", tr->GetName());
                    out.AddFriend(tr->GetName(), tf);
                } else {
                    //out = (TTree*)key->ReadObj();
                    out.CopyAddresses((TTree*)key->ReadObj());
                    cont = true;
                }
            }
            }
            key = (TKey*)keys->After(key);
        }
        tsf = (TSystemFile*)input->After(tsf);
    }
}

/**
* makeAllChained(TChain& out, TList* input)
* author  Nagni
* version 1.0 - 1 September 2004
* 
* version 1.1 - 27 December 2004
* Checks on TFiles/TList existance
* 
* Create a chain with all the files into the "input" parameter
* returning a TChain
*
* Parameters:
* 	input 	   - the input Tlist of files
* 	out 	   - the returned TChain
*
*/
void Utility::makeAllChained(TChain& out, TList* input){
    TList           *keys;
    TKey            *key;
    TList           *resList;
    TTree           *tr;
    TFriendElement  *tfe;
    string          *base;
    string          *target;
    string          *className;
    unsigned int     loc;

    TSystemFile *tsf = (TSystemFile*)input->First();
    if (tsf->IsZombie()) return;

    while(tsf){
        base    = new string(tsf->GetTitle());
        base->append("/");
        base->append(tsf->GetName());
        //printf("baseAppend %s       \n", base->c_str());
	
        TFile *tf = new TFile(base->c_str());
	if (tf->IsZombie()) {
	  tsf = (TSystemFile*)input->After(tsf);
	  continue;
	}	

        keys = tf->GetListOfKeys();
        key = (TKey*)keys->First();
        while(key){
            className = new string(key->GetClassName());
            loc = className->find("Tree", 0);
            //printf("%s className \n", className->c_str());
            if(loc != string::npos){
		tr = (TTree*)key->ReadObj();
		if (tr->GetEntries() > 0){
                    out.Add(base->c_str());
		}
            }
            key = (TKey*)keys->After(key);
        }
        tsf = (TSystemFile*)input->After(tsf);
    }
}

// check to see if the Event class is in the dictionary
// if it is not load the definition in the libXXX.so
/*void Configurator::checkLib(){
  if (!TClassTable::GetDict("pamela::TmtcEvent")){
    //  Load YODA/PAMELA class Library
    gSystem->Load(Configurator::libYoda);
  }
}*/

/**
* getFile (TString base, TString packetType, TString subType = "Event")
* author  Nagni
* version 1.0 - 1 September 2004
* 
* version 1.1 - 27 December 2004
* Checks on TFiles/TList existance
*
* Taking advantage of the define structure of YODA created directory
* this function retrieve a specific file from the specified directory.
* Parameters:
* 	base 	   - the path to the root directory for the specific
*	       		  Pamela unpack session 
* 	packetType - one of the Pamela PacketTypes (see in the end)
* 	subType    - can have value: "Event" (default) or "Header"
*
*/
TFile* Utility::getFile(TString base, TString packetType, TString subType = "Event"){
  
  TSystemDirectory *targetDir  = new TSystemDirectory("", base);
  
  TList       *filesList       = new TList;
  TFile       *reportFile;
  TSystemFile *tsf;
  string      *tmpString;
  
  /*
    It's an oversized use to find files but in future could be a usefulle generalization;
    up to now it's usefull just to make friends a Physics device.ROOT with it's direct Header.ROOT file
    because (for now) there is no sense to make friends such couples because of no guarantee
    on OBT and packetCounter beetween different downlinks.
  */
  tmpString = new string(".");
  tmpString->append(packetType);
  tmpString->append(".");
  tmpString->append(subType);
  tmpString->append(".");
  
  digForFiles(*filesList, targetDir, tmpString->c_str());
  if (filesList->IsEmpty()) return 0;
  
  targetDir  = new TSystemDirectory("", base);
  
  //Takes the physic header file 
  tsf = (TSystemFile*)filesList->First();
  //   printf("Title: %s   ----------------- Name: %s       \n", tsf->GetTitle(), tsf->GetName());
  tmpString    = new string(tsf->GetTitle());
  tmpString->append("/");
  tmpString->append(tsf->GetName());
  return new TFile(tmpString->c_str());      
}

/**
* int getLastNotZeroBin (TH1 *histo)
* author  Nagni
* version 1.0 - 22 February 2005
* 
* Returns the histogram smaller bin not equal to zero.
* Parameters:
* 	histo 	   - the histogram object
*
* Return:
*       int        - the value of the bin
*
*/
Int_t Utility::getLastNotZeroBin(TH1 *histo){
  Int_t  lastBin = 0;
  Int_t  tempBin = 0;
  Stat_t minVal  = 0;
  Stat_t tempVal = 0;
  Int_t  range = histo->GetNbinsX();

  tempBin = histo->GetMaximumBin();  
  tempVal = histo->GetBinContent(tempBin);
  minVal  = tempVal;
  lastBin = tempBin;  

  for (Int_t i = histo->GetMaximumBin()  + 1; i < range; i++){
    tempVal = histo->GetBinContent(i);
    if ((tempVal != 0) && (tempVal < minVal)) {
      minVal  = tempVal;
      lastBin = i;
    }
  }
  //In the end I add 10% to the retrieved value
  return (Int_t)(lastBin*1.10);
}

/**
* int getFirstNotZeroBin (TH1 *histo)
* author  Nagni
* version 1.0 - 22 February 2005
* 
* Returns the histogram greater bin not equal to zero.
* Parameters:
* 	histo 	   - the histogram object
*
* Return:
*       int        - the value of the bin
*
*/
Int_t Utility::getFirstNotZeroBin(TH1 *histo){
  Int_t  lastBin = 0;
  Int_t  tempBin = 0;
  Stat_t minVal  = 0;
  Stat_t tempVal = 0;

  tempBin = histo->GetMaximumBin();  
  tempVal = histo->GetBinContent(tempBin);
  minVal = tempVal;
  lastBin = tempBin;  

  for (Int_t i = histo->GetMaximumBin() - 1; i > 0; i--){
    tempVal = histo->GetBinContent(i);
    if ((tempVal != 0) && (tempVal < minVal)) {
      minVal  = tempVal;
      lastBin = i;
    }
  }
  //In the end I subtract 10% to the retrieved value
  return (Int_t)(lastBin*0.90);
}
