#include <log4cxx/logger.h>
#include <YFile.h>

using namespace log4cxx;
using namespace yngn;
using namespace yngn::util;
using namespace yngn::YException;

    TFile     *YFile::yfile  = 0;
    static LoggerPtr  logger        = Logger::getLogger(_T("yngn.util.YFile"));

    /**
    * Open/copy a file from remote (rfio) or local path.
    * This solution have been implemented mainly because the CASTOR system could have performance problem in 
    * case of interactive file opening: the use of the "copy" flag, allow the minimum change for the existing 
    * softwares.
    * @param url     Path to the database to be used.
    * @param options Path to the database to be used.
    * @param copy    Flag to define if the file have to be copied on a specified path or not. Default si false.
    * @param path    Where to copy the file. Default is local.
    */
    TFile* YFile::Open(const char *url, const char* options, bool copy, const char *path) throw (YNotExistingFileException, YSystemCommandException) {
        const char *name;
        if ((copy) && (strlen(strstr(url, "rfio:/")) > 0)){
            char cmd[999];
            //Here do the copy of the remote file
            if (copy){
                strcpy (cmd,"rfcp ");
                strcat (cmd,url+5);
                strcat (cmd,"  ");
                strcat (cmd, path);
                if (system(cmd) == 0) throw YSystemCommandException(cmd);
                name  = strrchr(url,'/');
            } 
        } else {
                name = url;
        }
        yfile = TFile::Open(name, options);
        if (yfile == 0) throw YNotExistingFileException(url);
        return yfile;
    }
