
#include <log4cxx/logger.h>
#include <log4cxx/basicconfigurator.h>
#include <log4cxx/fileappender.h>
#include <log4cxx/patternlayout.h>
#include <log4cxx/propertyconfigurator.h>

#include <TSQLServer.h>
#include <TSQLResult.h>
#include <YSQLConnection.h>
#include <PamelaDBOperations.h>
#include <YException.h>

#include <cstdlib>
#include <iostream>
#include <errno.h>

extern "C" {
#include <dirent.h>
}

using namespace log4cxx;
using namespace std;
using namespace yngn::YException;
using namespace pamela;

static LoggerPtr logger = Logger::getLogger(_T("YodaProfiler"));

/*
NOTE!!!
This program assume that on the '.' directory is present a structure having a

- filesFromYoda folder containing the unpacked data
*/

int main(int argc, char* argv[]) {

/*
    if (argc < 2){
    printf("You have to insert at least the file to analyze \n");
    printf("Try '--help' for more information. \n");
    exit(1);
  }  

  if (!strcmp(argv[1], "--help")){
        printf( "Usage: -exec[operation] [OPTIONS] \n");
        printf( "\t --help                 Print this help and exit \n");
        printf( "\t OPTIONS: \n");
        
        printf( "\t -sqlParams[path]       Path to the configuration file to connect to the Database server \n");
        printf( "\t The configuration file (remember to chmod it to '500') have to be in the format \n");
        printf( "\t #HOST=hostname \n");
        printf( "\t #USER=username \n");
        printf( "\t #PSW=password \n");
        printf( "\t #DB=databaseName \n");
        
        printf( "\t -host[name]       	   The name of the host where the database is installed\n");
        printf( "\t -user[name]       	   The name of the user accessing to the database\n");
        printf( "\t -psw[name]       	   The password of the user accessing to the database\n");
        
        printf( "\t Notice that by default [-host -name -password -database] overload the [-sqlParams] param \n");
        
        printf( "\t -exec[nameOperation]   Execute the required operation");
        printf( "\t -rawPath[path]         Path to the raw file \n");
        printf( "\t -rawFile[name]         Name of the raw file \n");
        
        printf( "\n \t Operations list: \n");
        printf( "\t insertPamelaRawFile -rawPath[path] -rawFile[name]); \n");
        exit(1);
  }

  for (int i = 2; i < argc; i++){
    if (!strcmp(argv[i], "-outDir")){
        if (++i >= argc){
            printf( "-outDir needs arguments. \n");
            printf( "Try '--help' for more information. \n");
            exit(1);
        } else {
            outDir = argv[i];
        }
    }

    if (!strcmp(argv[i], "-xslPath")) 
    	if (++i >= argc){
            printf( "-xslPath needs arguments. \n");
            printf( "Try '--help' for more information. \n");
            exit(1);
        } else {
        	xslPath = argv[i];
        	continue;
        }
    }
	
  */  
    
    
    stringstream oss;
   
    TSQLServer *sqlServer   = 0;
    char  *rawPathName      = argv[1];
    char  *rawFileName      = argv[2];
    char  *symbolicName     = "";

    char  *result = NULL;
    char   buffer[999];
    char  *host = argv[3];
    char  *user = argv[4];
    char  *password = argv[5];
    char  *rootPathName      = argv[6];
    char  *rootFileName      = argv[7];
    

    //Here I have to put some check for the arguments......
    /*
    ifstream config(argv[4]);
    if (! config.is_open())
      { cout << "Error opening file"; exit (1); }
    while (! config.eof() )
      {
	config.getline (buffer,255);
        
	if (strstr(buffer, "=") != NULL){
	  result = strtok( buffer, "=" );
	  while( result != NULL ) {
	    //The fisrt strok skip the "user" or "password" keys
	    result = strtok( NULL, delims );
	    user = strtok( NULL, delims );
	  }	
	}
      }*/
  try{
    oss.str("");
    sqlServer = yngn::sql::YSQLConnection::getConnection(host, user, password);    
  } catch (YException exc) {
    cout << exc.print();
    exit(1);
  }

      //Insert a Raw file in GL_RAW
//-------------------------------------------------------------------------------------------
   try {
     PamelaDBOperations::insertPamelaRawFile(sqlServer, rawPathName, rawFileName);
    } catch (YException exc) {
        cout << "Eccezione! " << exc.print() << "\n" ;
    }
//-------------------------------------------------------------------------------------------

      //Insert single unpack ROOTs files in GL_ROOT
//-------------------------------------------------------------------------------------------
   try {
     PamelaDBOperations::insertPamelaRootFiles(sqlServer, rootPathName, rootFileName, rawPathName, rawFileName);
    } catch (YException exc) {
        cout << "Eccezione! " << exc.print() << "\n" ;
    }
//-------------------------------------------------------------------------------------------

   
//Update a single GL_RAW record with its BOOT_NUMBER
//-------------------------------------------------------------------------------------------
   try {
     PamelaDBOperations::assignBOOT_NUMBER(sqlServer, rawPathName, rawFileName);
   } catch (YException exc) {
     cout << "Eccezione! " << exc.print() << "\n" ;
   }
//-------------------------------------------------------------------------------------------
      
      //Insert a record in GL_TIMESYNC with data relative to a single unpack
//-------------------------------------------------------------------------------------------
   try {
     PamelaDBOperations::insertPamelaGL_TIMESYNC(sqlServer, rawPathName, rawFileName);
   } catch (YException exc) {
     cout << "Eccezione! " << exc.print() << "\n" ;
   }

 
//-------------------------------------------------------------------------------------------
      //Generate the Registry files for a single unpack
//-------------------------------------------------------------------------------------------
    try {
    	PamelaDBOperations::createPamelaRegistry(sqlServer, rawPathName, rawFileName, true);
    } catch (YException exc) {
      cout << "Eccezione! " << exc.print() << "\n" ;
    }
//-------------------------------------------------------------------------------------------

      //Insert in GL_RUN runs information records relative to a single unpack
//-------------------------------------------------------------------------------------------
    try {
     	PamelaDBOperations::insertPamelaRUN(sqlServer, rawPathName, rawFileName);
    } catch (YException exc) {
      cout << "Eccezione! " << exc.print() << "\n" ;
    }
    
//-------------------------------------------------------------------------------------------

      //Insert in GL_CALO_CALIB calibration information records relative to a single unpack
//-------------------------------------------------------------------------------------------
    try {
     	PamelaDBOperations::insertNEW_CALO_CALIB(sqlServer, rawPathName, rawFileName);
    } catch (YException exc) {
      cout << "Eccezione! " << exc.print() << "\n" ;
    }
//-------------------------------------------------------------------------------------------


      //Insert in GL_S4_CALIB calibration information records relative to a single unpack
//-------------------------------------------------------------------------------------------
    try {
     	PamelaDBOperations::insertNEW_S4_CALIB(sqlServer, rawPathName, rawFileName);
     } catch (YException exc) {
      cout << "Eccezione! " << exc.print() << "\n" ;
    }
//-------------------------------------------------------------------------------------------

      //Insert in GL_TRK_CALIB calibration information records relative to a single unpack
//-------------------------------------------------------------------------------------------
    try {
       PamelaDBOperations::insertNEW_TRK_CALIB(sqlServer, rawPathName, rawFileName);
     } catch (YException exc) {
      cout << "Eccezione! " << exc.print() << "\n" ;
    }
//---------------------------------------------------------------------------------------
  sqlServer->Close();
  logger->info("<-------------------------------END UNPACKING------------------------------->\n");
  //return 1;
}
