#ifndef PAMELA_DB_OPERATIONS_H
#define PAMELA_DB_OPERATIONS_H

#include <RegistryEvent.h>
#include <TSQLServer.h>
#include <YException.h>
#include <iostream>
#include <list>
#include <cOrbit.h>

using namespace yngn::YException;
using namespace pamela;


        /**
         * Collections of Pamela specific operations over a database
         */
        class PamelaDBOperations {
        private:

        
            typedef std::list<const char*> pcksList;

	    static void getPacketsNames(pcksList &pcksNames){
	    	pcksNames.push_back("PhysEndRun");
	    	pcksNames.push_back("CalibCalPulse1");
	    	pcksNames.push_back("CalibCalPulse2");
	    	pcksNames.push_back("Physics");
	    	pcksNames.push_back("CalibTrkBoth");
	    	pcksNames.push_back("CalibTrk1");
	    	pcksNames.push_back("CalibTrk2");
	    	pcksNames.push_back("CalibTof");
	    	pcksNames.push_back("CalibS4");
	    	pcksNames.push_back("CalibCalPed");
	    	pcksNames.push_back("Calib1_Ac1");
	    	pcksNames.push_back("Calib2_Ac1");
	    	pcksNames.push_back("Calib1_Ac2");
	    	pcksNames.push_back("Calib2_Ac2");
	    	pcksNames.push_back("CalibCal");
	    	pcksNames.push_back("RunHeader");
	    	pcksNames.push_back("RunTrailer");
	    	pcksNames.push_back("CalibHeader");
	    	pcksNames.push_back("CalibTrailer");
	    	pcksNames.push_back("InitHeader");
	    	pcksNames.push_back("InitTrailer");
	    	pcksNames.push_back("EventTrk");
	    	pcksNames.push_back("Log");
	    	pcksNames.push_back("VarDump");
	    	pcksNames.push_back("ArrDump");
	    	pcksNames.push_back("TabDump");
	    	pcksNames.push_back("Tmtc");
	    	pcksNames.push_back("Mcmd");
	    	pcksNames.push_back("ForcedFECmd");
	    	pcksNames.push_back("Ac1Init");
		pcksNames.push_back("CalInit");
	    	pcksNames.push_back("TrkInit");
	    	pcksNames.push_back("TofInit");
	    	pcksNames.push_back("TrgInit");
	    	pcksNames.push_back("NdInit");
	    	pcksNames.push_back("S4Init");
	    	pcksNames.push_back("Ac2Init");
	    	pcksNames.push_back("CalAlarm");
	    	pcksNames.push_back("Ac1Alarm");
	    	pcksNames.push_back("TrkAlarm");
	    	pcksNames.push_back("TrgAlarm");
	    	pcksNames.push_back("TofAlarm");
	    	pcksNames.push_back("S4Alarm");
	    	pcksNames.push_back("Ac2Alarm");	    	
	    	pcksNames.push_back("TsbT");
	    	pcksNames.push_back("TsbB");
	    }

	    static const char* getID_RAW(TSQLServer *conn, const char *rawPathName, const char *rawFileName) 
                      throw (YSQLNotConnectedException, YSQLQueryException);

	    static const char* setGeo(cOrbit *orbit, RegistryEvent* &reg) 
                      throw (YSQLNotConnectedException, YSQLQueryException);
                      
            static int rootFilesWalker(TSQLServer *conn, const char *dirPath, const char *idRaw) 
                      throw (YSQLNotConnectedException, YSQLQueryException);
                      
            static int insertPamelaRootFiles(TSQLServer *conn, const char *pathName, const char *fileName, const char *idPath)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertPamelaTM_HEADER(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertPamelaGL_TIMESYNC(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertPamelaTM_TIMESYNC(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int deletePamelaDuplicate(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException);

	    static int assignPamelaTIMESYNC(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertPamelaPacket(TSQLServer *conn, const char *pathName, const char *eventFileName, const char *headerFileName)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int createPamelaRegistry(TSQLServer *conn, const char *idRaw, bool overwrite)
                      throw (YSQLNotConnectedException, YSQLQueryException, YNotExistingFileException, YExistingFileException);

            static int insertPamelaRUN(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException, YNotExistingFileException, YEmptyObjectException);

            static int populateTM_CALO_CALIB(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException, YEmptyObjectException);

            static int populateTM_S4_CALIB(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException, YEmptyObjectException);

            static int populateTM_TRK_CALIB(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException, YEmptyObjectException);

	    static int insertNEW_CALO_CALIB(TSQLServer *conn, ULong64_t time, int section, unsigned long reg_ev, unsigned long id_reg, unsigned long tm_id)
                      throw (YSQLNotConnectedException, YSQLQueryException, YEmptyObjectException, YProcessErrorException);

	    static int insertNEW_S4_CALIB(TSQLServer *conn, float paramfit0, float paramfit1, ULong64_t time, unsigned long reg_ev, unsigned long id_reg, unsigned long tm_id)
                      throw (YSQLNotConnectedException, YSQLQueryException, YEmptyObjectException, YProcessErrorException);

	    static int insertNEW_TRK_CALIB(TSQLServer *conn, unsigned long id_reg, unsigned long reg_ev1, unsigned long reg_ev2, ULong64_t time, const char* tm_id1, const char* tm_id2)
                      throw (YSQLNotConnectedException, YSQLQueryException, YEmptyObjectException, YProcessErrorException);

        public: 
            static const char *PamelaDBOperations::TM_CALO_CALIB;
            static const char *PamelaDBOperations::TM_S4_CALIB;
            static const char *PamelaDBOperations::TM_TRK_CALIB;
            static const char *PamelaDBOperations::TM_REGISTRY;
            static const char *PamelaDBOperations::TM_HEADER;
	    static const char *PamelaDBOperations::TM_TIMESYNC;

	    static int insertPamelaRootFiles(TSQLServer *conn, const char *pathName, const char *fileName, const char *rawPathName, const char *rawFileName)
	     	      throw (YSQLNotConnectedException, YSQLQueryException);

            static bool insertPamelaRawFile(TSQLServer *conn, const char *pathName, const char *fileName)
                      throw (YSQLNotConnectedException, YSQLQueryException, YSQLDuplicateRowException);

            static int insertPamelaUnpacking(TSQLServer *conn, const char *pathName, const char *rawPathName, const char *rawFileName)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertPamelaGL_TIMESYNC(TSQLServer *conn, const char *rawPathName, const char *rawFileName)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int createPamelaRegistry(TSQLServer *conn, const char *rawPathName, const char *rawFileName, bool overwrite)
                      throw (YSQLNotConnectedException, YSQLQueryException, YNotExistingFileException, YExistingFileException);

            static int insertPamelaRUN(TSQLServer *conn, const char *rawPathName, const char *rawFileName)
                      throw (YSQLNotConnectedException, YSQLQueryException, YNotExistingFileException, YEmptyObjectException);

	    static int assignBOOT_NUMBER(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int assignBOOT_NUMBER(TSQLServer *conn, const char *rawPathName, const char *rawFileName)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertNEW_CALO_CALIB(TSQLServer *conn, const char *rawPathName, const char *rawFileName)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertNEW_CALO_CALIB(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertNEW_S4_CALIB(TSQLServer *conn, const char *rawPathName, const char *rawFileName)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertNEW_S4_CALIB(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertNEW_TRK_CALIB(TSQLServer *conn, const char *rawPathName, const char *rawFileName)
                      throw (YSQLNotConnectedException, YSQLQueryException);

            static int insertNEW_TRK_CALIB(TSQLServer *conn, const char *idRaw)
                      throw (YSQLNotConnectedException, YSQLQueryException);
        };
#endif /* PAMELA_DB_OPERATIONS_H */
