#include <TObject.h>
#include <TFile.h>
#include <TObjString.h>
#include <TString.h>
#include <TTree.h>
#include <TArrayC.h>


using namespace std;
class DataItem : public TObject{
 public:
  string fileName;
  DataItem() : TObject(){}
  ~DataItem() {}
  
  virtual const char* toXML(char* tab = "") {}
  virtual void  fill(TArrayC*) {}
};

class McmdItem : public DataItem{
  public:
    string fileName;
    McmdItem() : DataItem(){}
    ~McmdItem() {}
    
    virtual const char* toXML(char* tab = "") {}
    virtual void  fill(TArrayC*) {}
};

class ElseItem : public McmdItem{
private:

 public:
  ElseItem::ElseItem() : McmdItem(){}
  ElseItem::~ElseItem() {}

  const char* ElseItem::toXML(char*);
  void  ElseItem::fill(TArrayC*) { }
};

class DownLinkItem : public McmdItem{
 public:
  unsigned int   rawModeSectors; // From 4 to 2048 sector to Downlink in RAW mode
  unsigned short rawMode;        // 0 = NormalMode         1 = RawMode
  unsigned short tmSel;          // 0 = TM I/F A       other = TM I/F B
  unsigned short fileId;         // 0 = File 1             1 = File 2
  unsigned int   orbitNumber;    // Number of the orbit
  unsigned short spareAdapt;     // Number of the orbit

  DownLinkItem() : McmdItem(){}
  ~DownLinkItem() {}
  
  void fill(TArrayC* data){ }
  const char* toXML(char*);
};


class TimeSyncItem : public McmdItem{
 public:
  unsigned int newTime;
  TimeSyncItem() : McmdItem(){}
  ~TimeSyncItem()  {}
  
  void fill(TArrayC* data);
  const char* toXML(char*);
};

//For now i dont store the Parameters sequence
class SelectOpModeItem : public McmdItem{
 public:
  unsigned short mode;
  unsigned short paramNumber;
  SelectOpModeItem() : McmdItem(){}
  ~SelectOpModeItem() {}

  void fill(TArrayC* data);
  const char* toXML(char*);
};

class BiteItem : public McmdItem{
 public:
  unsigned int fillerWord;
  BiteItem::BiteItem() : McmdItem(){}
  BiteItem::~BiteItem();

  void fill(TArrayC* data);
  const char* toXML(char* tab);
};


class McmdScan {
 private:
  //In compiled version will use the std::map
  McmdItem *mcmdItem;

 public:
 McmdScan::McmdScan() {}
 const char* McmdScan::extract(TArrayC *data, int id, char* tabs);
};
