#include <YMcmd.h>
#include <sstream>

//using namespace std;


  const char* ElseItem::toXML(char* tab = "") {
    std::stringstream 	oss;
    oss.str("");
    oss << tab << "<Else>\n";
    oss << tab << "</Else>\n";
    return oss.str().c_str();
  }


  
  
  const char* DownLinkItem::toXML(char* tab = ""){
    stringstream oss;
    oss.str("");
    return oss.str().c_str();
  }





  void TimeSyncItem::fill(TArrayC* data){
    newTime = (((unsigned int)data->At(0)<<24)&0xFF000000) + (((unsigned int)data->At(1)<<16)&0x00FF0000) + (((unsigned int)data->At(2)<<8)&0x0000FF00) + (((unsigned int)data->At(3))&0x000000FF);
  }

  const char* TimeSyncItem::toXML(char* tab = ""){
    stringstream oss;
    oss.str("");
    oss << tab << "<param name = 'newTime'>" <<  newTime << "</param>\n";
    return oss.str().c_str();
  }





  void SelectOpModeItem::fill(TArrayC* data){
    /*for (int i = 0; i<data->GetSize(); i++){
      printf("array[%i]: %x", i, data->At(i));
      }*/
    mode        = data->At(1)&0xFF;
    paramNumber = (((unsigned int)data->At(2)<<8)&0x00000100) + (((unsigned int)data->At(3))&0x000000FF);
  }

  const char* SelectOpModeItem::toXML(char* tab = ""){
    stringstream oss;
    oss.str("");
    oss << tab << "<param name = 'mode'>"        << hex << mode << dec << "</param>\n";
    oss << tab << "<param name = 'paramNumber'>" << paramNumber << "</param>\n";
    return oss.str().c_str();
  }




  
  void BiteItem::fill(TArrayC* data){
    fillerWord =  (((unsigned int)data->At(0)<<8)&0x0000FF00) + (((unsigned int)data->At(1))&0x000000FF);
  }

  const char* BiteItem::toXML(char* tab = ""){
    stringstream oss;
    oss.str("");
    oss << tab << "<param name = 'fillerWord'>" <<  fillerWord << "</param>\n";
    return oss.str().c_str();
  }


 const char* McmdScan::extract(TArrayC *data, int id, char* tabs){
   switch(id){
   case 0xE0:
     mcmdItem = new TimeSyncItem();
     break;
   case 0x33:
     mcmdItem = new SelectOpModeItem();
     break;
   default:
     mcmdItem = new ElseItem();
     break;
   }
   mcmdItem->fill(data);
   return mcmdItem->toXML(tabs);
 }

