#ifndef YEXCEPTION_H
#define YEXCEPTION_H

#include <exception>
#include <stdio.h>

using namespace std;

namespace yngn {
    namespace YException {
        class YException: public exception {
    
            private:
    
            protected:
                const char *message;
                char buff [100];
            public:
                YException(const char *msg = "message"): message(msg){ }
                virtual ~YException () throw(){ }
                virtual const char* print () const throw () { return message; }
        };

        class NotFoundEnvironmentVarException: public YException {
            public:
                NotFoundEnvironmentVarException::NotFoundEnvironmentVarException(const char* msg):  YException(msg) {}
                NotFoundEnvironmentVarException::~NotFoundEnvironmentVarException () throw(){ }
        };

        class YSQLNotConnectedException: public YException {
            public:
                YSQLNotConnectedException::YSQLNotConnectedException(const char* msg):  YException(msg) {}
                YSQLNotConnectedException::~YSQLNotConnectedException () throw(){ }
        };

        class YSQLQueryException: public YException {
            public:
                YSQLQueryException::YSQLQueryException(const char* msg):  YException(msg) {}
                YSQLQueryException::~YSQLQueryException () throw(){ }
        };
        
        class YSQLDuplicateRowException: public YException {
            public:
                YSQLDuplicateRowException::YSQLDuplicateRowException(const char* msg):  YException(msg) {}
                YSQLDuplicateRowException::~YSQLDuplicateRowException () throw(){ }
        };

       class YNotExistingFileException: public YException {
            public:
                YNotExistingFileException::YNotExistingFileException(const char* msg):  YException(msg) {}
                YNotExistingFileException::~YNotExistingFileException () throw(){ }
        };

       class YExistingFileException: public YException {
            public:
                YExistingFileException::YExistingFileException(const char* msg):  YException(msg) {}
                YExistingFileException::~YExistingFileException () throw(){ }
        };

       class YEmptyObjectException: public YException {
            public:
                YEmptyObjectException::YEmptyObjectException(const char* msg):  YException(msg) {}
                YEmptyObjectException::~YEmptyObjectException () throw(){ }
        };
       class YSystemCommandException: public YException {
            public:
                YSystemCommandException::YSystemCommandException(const char* msg):  YException(msg) {}
                YSystemCommandException::~YSystemCommandException () throw(){ }
        };
       class YProcessErrorException: public YException {
            public:
                YProcessErrorException::YProcessErrorException(const char* msg):  YException(msg) {}
                YProcessErrorException::~YProcessErrorException () throw(){ }
        };
    }
}
#endif /* YEXCEPTION_H */
