/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/04 12:37:45 $
 * $Revision: 5.1 $
 * 
 * Header file for the algorithms used to read the techmodel tracker events.
 */

#ifndef ANTICOUNTER_READER_H
#define ANTICOUNTER_READER_H

#include "techmodel/TechmodelAlgorithm.h"
#include "event/PamelaRun.h"
#include "event/physics/anticounter/AnticounterEvent.h"


namespace pamela {
  namespace anticounter {
    /**
     * Algorithm to read techmodel anticounter physics events.
     */
    class AnticounterReader: public pamela::techmodel::TechmodelAlgorithm {
    private:
      /**
       * The physics event that is created in this algorithm.
       */
      AnticounterEvent *anticounter;
    public:
      AnticounterReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int);
      virtual void RunEvent(int, const char[] , long int);
      virtual std::string GetVersionInfo(void) const;
    };
  }
}

#endif /* ANTICOUNTER_READER_H */
