/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/04 12:37:46 $
 * $Revision: 5.1 $
 * 
 * Header file for the algorithms used to read the techmodel tracker events.
 */

#ifndef TRACKER_READER_H
#define TRACKER_READER_H

#include "techmodel/TechmodelAlgorithm.h"
#include "event/PamelaRun.h"
#include "event/physics/tracker/TrackerEvent.h"


namespace pamela {
  namespace tracker {
    /**
     * Algorithm to read techmodel tracker physics events.
     */
    class TrackerReader: public pamela::techmodel::TechmodelAlgorithm {
    
    private:
      /**
       * The physics event that is created in this algorithm.
       */
      TrackerEvent* tracker;
    public:
      TrackerReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int);
      virtual void RunEvent(int, const char[] , long int);
      virtual std::string GetVersionInfo(void) const;
    };
  }
}

#endif /* TRACKER_READER_H */
