/** @file
 * $Author: kusanagi $
 * $Date: 2005/05/28 10:44:13 $
 * $Revision: 4.4 $
 * 
 * Header file for the algorithms used to read the techmodel tracker events.
 */

#ifndef S4_READER_H
#define S4_READER_H

#include "techmodel/TechmodelAlgorithm.h"
#include "event/PamelaRun.h"
#include "event/physics/S4/S4Event.h"


namespace pamela {
  namespace S4 {
    /**
     * Algorithm to read techmodel S4 physics events.
     */
    class S4Reader: public pamela::techmodel::TechmodelAlgorithm {
    private:
      /**
       * The physics event that is created in this algorithm.
       */
      S4Event *s4;
      int haveData(const char[], long int);
    public:
      S4Reader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int);
      virtual void RunEvent(int, const char[] , long int);
      virtual std::string GetVersionInfo(void) const;
    };
  }
}

#endif /* S4_READER_H */
