/** @file
 * $Author: kusanagi $
 * $Date: 2005/03/04 15:54:11 $
 * $Revision: 3.0 $
 * 
 * Header file for the algorithms used to read the techmodel calorimeter events.
 */

#ifndef TRIGGER_READER_H
#define TRIGGER_READER_H

#include "techmodel/TechmodelAlgorithm.h"
#include "event/PamelaRun.h"
#include "event/physics/trigger/TriggerEvent.h"


namespace pamela {
  namespace trigger {
    /**
     * Algorithm to read fligthmodel trigger physics events.
     */
    class TriggerReader: public pamela::techmodel::TechmodelAlgorithm {
    private:
      /**
       * The physics event that is created in this algorithm.
       */
      TriggerEvent *trigger;
    public:
      TriggerReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int);
      virtual void RunEvent(int, const char[] , long int);
      virtual std::string GetVersionInfo(void) const;
    };
  }
}

#endif /* TRIGGER_READER_H */
