************************************************************************
*     
*     Common commontracker.f
*     
*     contains tracker general variables definitions
*     
*     to be included in:
*     - ../readraw/readraw.F
*     - ../reduction/reduction.f
*     - ../reduction/fillpedsig.f
*     - ../reduction/filladc.f
*     - ../reduction/cncomp.f
*     - ../reduction/cnoise.f
*     - ../reduction/cutcn.f
*     - ../analysis/preanalysis.f
*     - ../analysis/analysis.f
*     - ../align/align.f
*     - ../magnet/read_B.f
*     - !???
*     
*     parameters:
*     - !???
*     
*************************************************************************


c------------------------------------------------------------------------
c     
c     HBOOK initialization variable
c     
c------------------------------------------------------------------------

      parameter (NWPAWC=6500000)
      common/PAWC/HMEM(NWPAWC)


c------------------------------------------------------------------------
c     
c     ntuples id numbers and parameters
c     
c------------------------------------------------------------------------

      parameter (ntp_runinfo=19) !RUNINFO
      parameter (ntp_level0=20) !LEVEL0
      parameter (ntp_level1=21) !LEVEL1
      parameter (ntp_level2=22) !LEVEL2
      parameter (ntp_level3=23) !LEVEL3


c      parameter (nclstrmax=1000) !maximum number of clusters per event
      parameter (nclstrmax=500)
      parameter (nclstrp=17)    !maximum number of strips to be checked for 
                                ! inclusion in the cluster
      parameter (maxlength=nclstrmax*nclstrp) !maximum number of strip belonging
                                ! to clusters for the whole event


c------------------------------------------------------------------------
c     
c     spectrometer parameters
c     
c------------------------------------------------------------------------

      parameter (nviews=12)     !number of views
      parameter (nplanes=nviews/2) !number of planes
      parameter (nladders_view=3) !number of ladders per view
      parameter (nva1_ladder=8) !number of VA1s per ladder (per side)
      parameter (nstrips_va1=128) !number of strips per VA1


      parameter (nstrips_ladder=nstrips_va1*nva1_ladder) !number of strips
                                ! per ladder
      parameter (nva1_view=nva1_ladder*nladders_view) !number of VA1s per 
                                ! view
      parameter (nstrips_view=nstrips_va1*nva1_view) !number of strips per 
                                ! view
      parameter (nva1=nva1_view*nviews) !number of VA1s
      parameter (nstrips=nstrips_va1*nva1) !number of strips

      parameter (pitchX=51.)
      parameter (pitchY=66.5)
      
      
c------------------------------------------------------------------------
c     
c     pedestal, sigma and badstrip variables
c     
c------------------------------------------------------------------------

      real pedestal(nviews,nva1_view,nstrips_va1) !pedestal value
      real pedestal_t(nviews,nva1_view,nstrips_va1) !pedestal truncated value

      real sigma(nviews,nva1_view,nstrips_va1) !sigma value
      real sigma_t(nviews,nva1_view,nstrips_va1) !sigma truncated value

      integer bad(nviews,nva1_view,nstrips_va1) !bad strip flag matrix
                                ! (bad=1 --> good strip, bad=0 --> bad strip)

      common/pedsigbad/pedestal,pedestal_t,sigma,sigma_t,bad







c     todo!???

      real adc(nviews,nva1_view,nstrips_va1)
c     real adc1(nviews,nva1_view,nstrips_va1)!per check della compressione

      common/adc_value/adc
!     ,adc1!per check della compressione








c------------------------------------------------------------------------
c     
c     common noise computation
c     
c------------------------------------------------------------------------
      parameter (scut=3.)
c      parameter (nch=50)
c      parameter (interval=10)

      real cn(nviews,nva1_view) !common noise value

      integer clstr(nviews,nva1_view,nstrips_va1) !flag matrix to mark 
                                ! strips with signal and exclude them from
                                ! common noise computation

      integer strange(nviews,nva1_view,nstrips_va1) !flag matrix to mark 
                                ! strips with unusually high or low signal and
                                ! exclude them from common noise computation

      common/cn/cn,clstr,strange


c------------------------------------------------------------------------
c     
c     cluster seed cuts
c     
c------------------------------------------------------------------------
      parameter (clcutx=7.)     !cluster seed cut (to esclude particles in CN
                                ! computation and to find clusters in data
                                ! reduction)
      parameter (clcuty=7.)


c------------------------------------------------------------------------
c     
c     common noise inclusion cut
c     
c------------------------------------------------------------------------
      parameter (cnincut=2.)    !cut to include strips in cluster definition
                                ! during common noise computation


c------------------------------------------------------------------------
c     
c     cluster finding inclusion cut
c     
c------------------------------------------------------------------------
      parameter (incutx=4.)     !cut to include strips in cluster definition
                                ! during cluster finding procedure
      parameter (incuty=4.)


c------------------------------------------------------------------------
c     
c     eta-i computation
c     
c------------------------------------------------------------------------
c      parameter (nn=100)        !eta function histos id number

c      real eta2(nclstrmax),eta3(nclstrmax),eta4(nclstrmax) !eta-i arrays

c      common/eta/eta2,eta3,eta4


      parameter (id_hi_eta2=200000)
      parameter (id_hi_eta3=300000)
      parameter (id_hi_eta4=400000)



c------------------------------------------------------------------------
c     
c     track selection for alignment
c     
c------------------------------------------------------------------------
      parameter (id_hi_residuals=10000) !residuals histos id number

      parameter (nnn=1000)       !chi square histos id number

      real reslim(28)         !tagli sulla buona traccia

      real resX1min,resX1max      !tagli sugli scarti per decidere tracce buone
      real resX2min,resX2max
      real resX3min,resX3max
      real resX4min,resX4max
      real resX5min,resX5max
      real resX6min,resX6max
      real resY1min,resY1max
      real resY2min,resY2max
      real resY3min,resY3max
      real resY4min,resY4max
      real resY5min,resY5max
      real resY6min,resY6max
      real chiXmin,chiXmax
      real chiYmin,chiYmax

      equivalence (reslim(1),resX1min),(reslim(2),resX1max),
     +     (reslim(3),resX2min),(reslim(4),resX2max),
     +     (reslim(5),resX3min),(reslim(6),resX3max),
     +     (reslim(7),resX4min),(reslim(8),resX4max),
     +     (reslim(9),resX5min),(reslim(10),resX5max),
     +     (reslim(9),resX6min),(reslim(10),resX6max),
     +     (reslim(11),resY1min),(reslim(12),resY1max),
     +     (reslim(13),resY2min),(reslim(14),resY2max),
     +     (reslim(15),resY3min),(reslim(16),resY3max),
     +     (reslim(17),resY4min),(reslim(18),resY4max),
     +     (reslim(19),resY5min),(reslim(20),resY5max),
     +     (reslim(19),resY6min),(reslim(20),resY6max),
     +     (reslim(21),chiXmin),(reslim(22),chiXmax),
     +     (reslim(23),chiYmin),(reslim(24),chiYmax)


c------------------------------------------------------------------------
c     
c     magnetic field
c     
c------------------------------------------------------------------------
      parameter (nx=29, ny=23, nz=101) !number of measures along X, Y and Z axes
      
      real*8 px(nx,3),py(ny,3),pz(nz,3) !coordinates of measure points:
                                ! e.g. py(ny,1) = Y coordinates of Bx (=1)
                                ! component of magnetic field

      real*8 b(nx,ny,nz,3),db(nx,ny,nz,3) !magnetic field values and error:
                                ! e.g. b(nx,ny,nz,2) = By (=2) component of
                                ! magnetic field measured in (nx, ny, nz)

      common/interpolation/px,py,pz,b,db


c     MECH_POS block:
      real x_mech_sensor(6,3,2) !mechanical project coordinates of silicon
      real y_mech_sensor(6,3,2) ! sensors centres (plane, ladderX, ladderY)
      real z_mech_sensor(6,3,2) ! in millimeters (ladderY=1 if near the hybrid,
      common/mechanical_positions/
     $     x_mech_sensor,y_mech_sensor,z_mech_sensor
                                ! =2 if far from it)


c     ALIGNP block:
c     silicon sensors alignment parameters:
      real dx_sensor(6,3,2)     !X translations (plane, ladderX, ladderY)
      real dy_sensor(6,3,2)     !Y translations
      real dz_sensor(6,3,2)     !Z translations 
      real omega_sensor(6,3,2)  !Z axis rotation angle
      real beta_sensor(6,3,2)   !X axis rotation angle
      real gamma_sensor(6,3,2)  !Y axis rotation angle

      common/allign_parameters/dx_sensor,dy_sensor,dz_sensor
     $     ,omega_sensor,beta_sensor,gamma_sensor
