
      parameter (nviews=12)     !number of views
      parameter (nplanes=nviews/2) !number of planes
      parameter (nladders_view=3) !number of ladders per view
      parameter (nva1_ladder=8) !number of VA1s per ladder (per side)
      parameter (nstrips_va1=128) !number of strips per VA1
      parameter (nstrips_ladder=nstrips_va1*nva1_ladder) !number of strips
                                ! per ladder
      parameter (nva1_view=nva1_ladder*nladders_view) !number of VA1s per 
                                ! view
      parameter (nstrips_view=nstrips_va1*nva1_view) !number of strips per 
                                ! view
      parameter (nva1=nva1_view*nviews) !number of VA1s
      parameter (nstrips=nstrips_va1*nva1) !number of strips
c------------------------------------------------------------------------
c     
c     pedestal, sigma and badstrip variables
c     
c------------------------------------------------------------------------

      real pedestal(nviews,nva1_view,nstrips_va1) !pedestal value
      real pedestal_t(nviews,nva1_view,nstrips_va1) !pedestal truncated value

      real sigma(nviews,nva1_view,nstrips_va1) !sigma value
      real sigma_t(nviews,nva1_view,nstrips_va1) !sigma truncated value

      integer bad(nviews,nva1_view,nstrips_va1) !bad strip flag matrix
                                ! (bad=1 --> good strip, bad=0 --> bad strip)

c      common/pedsigbad/pedestal,pedestal_t,sigma,sigma_t,bad
      common/pedsigbad/pedestal,sigma,bad
      common/pedsigbad_t/pedestal_t,sigma_t

*************************************************************************
*     
*     Common level0.f
*          
*************************************************************************
c     EVENT block:
      logical good0             !flag to mark good or noise events
      integer nev0              !level0 event number
      integer DAQmode(12)       !9  = full acquisition mode
                                !10 = compressed acquisition mode
                                !11 = compressed+full acquisition mode
      integer DSPnumber(12)     !view number
      integer DATAlength(12)    !data buffer length
      integer eventn(12)        !DSP event number
      integer nclust(12)        !nclust*2+1 = number of strips to be 
                                ! included in cluster
      integer cutc(12)          !cut to include strips in a cluster
      integer cutcl(12)         !cut to search for clusters
      integer addrcluster(12,3) !address of the greatest cluster(view,ladder)
      integer signcluster(12,3) !signal of the greatest cluster(view,ladder)
      integer fc(12)            !compression flag
      integer compressiontime(12) !DSP program compression time
      integer fl5(12)           !flag
      integer fl4(12)           !flag
      integer fl3(12)           !flag
      integer fl2(12)           !flag
      integer fl1(12)           !flag
      integer fl6(12)           !flag
      integer checksum(12)      !DSP header checksum
      integer pnum(12)          !peripheral number
      integer cmdnum(12)        !command number
      integer bid(12)           !board identifier
      integer alarm(12)         !alarm
      integer aswr(12)          !response length
c     DATA block:
      integer TOTDATAlength     !sum of all views datalength (to assign 
                                ! dimension to datatracker array)
      integer datatracker(49152) !data tracker buffer (.DAT raw data)

      common/level0/good0,nev0
     $     ,DAQmode,DSPnumber,DATAlength,eventn,nclust,cutc,cutcl
     $     ,addrcluster,signcluster,fc,compressiontime
     $     ,fl5,fl4,fl3,fl2,fl1,fl6,checksum
     $     ,TOTDATAlength,datatracker,pnum,cmdnum,bid,alarm,aswr
