// Implementation of the CalibTrkBothReader class.
 
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibTrkBothReader"));

/**
 * Constructor. 
 */
CalibTrkBothReader::CalibTrkBothReader(void): 
  TechmodelAlgorithm(PacketType::CalibTrkBoth, "TechmodelCalibTrkBothReader") { 
  logger->debug(_T("Constructor"));
  calibTrkBoth = new CalibTrkBothEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTrkBothReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalibTrkBothReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTrkBothReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &calibTrkBoth, calibTrkBoth->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the CalibTrkBoth event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void CalibTrkBothReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    memset(subData,  0, dataLength*sizeof(char));
    InputFile->read(subData, sizeof(subData));
    calibTrkBoth->calibTrkBothData        = new TArrayC(dataLength, subData);
}

