
// Implementation of the CalibCalPulse2Reader class.


#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>

extern "C" {
#include "CRC.h"  
    //Struct per il passaggio di dati da e verso la chiamata fortran
extern struct {
        int   iev;
        int   pstwerr[4];
        float pperror[4];
        float calpuls[4][11][96];
    } calpul_; 
    
    //external declaration of the Fortran function 
    void calpulse_(char*, long int*, int*);
}
#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/CalibCalPulse2Event.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibCalPulse2Reader"));

/**
 * Constructor. 
 */
CalibCalPulse2Reader::CalibCalPulse2Reader(void): 
  TechmodelAlgorithm(PacketType::CalibCalPulse2, "TechmodelCalibCalPulse2Reader") { 
  logger->debug(_T("Constructor"));
  calibCalPulse2 = new CalibCalPulse2Event();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibCalPulse2Reader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/CalibCalPulse2Reader.cpp,v 3.0 2005/03/04 15:54:11 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibCalPulse2Reader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calibCalPulse2, calibCalPulse2->Class());
}

/**
 * Unpack the CalibCalPulse2 event from an input file.
 */
void CalibCalPulse2Reader::RunEvent(int EventNumber, long int dataLength) throw (Exception){
    std::stringstream oss;       
    char        packetData[dataLength];
    int         ERROR;
    InputFile->read(packetData, sizeof(packetData));

    calpulse_(packetData, &dataLength, &ERROR);

    calibCalPulse2->unpackError = ERROR;

    if (ERROR != 0) {
        char *errmsg;
        switch (ERROR){
            case 1: errmsg = "CALORIMETER NOT FOUND";
        }
        oss.str("");
        oss << "Fortran77 function calpulse error code = " << ERROR
            <<  " " << errmsg;
        logger->warn(oss.str().c_str());
    } else {
       //Store the unpacked data
        calibCalPulse2->iev = calpul_.iev;
        memcpy(calibCalPulse2->pstwerr, calpul_.pstwerr, sizeof(calibCalPulse2->pstwerr));
        memcpy(calibCalPulse2->pperror, calpul_.pperror, sizeof(calibCalPulse2->pperror));
    //--------have to invert array because of FORTRAN <-> C different management of the indexes
        float tempCalpuls[96][11][4];
        memcpy(tempCalpuls, calpul_.calpuls, sizeof(tempCalpuls));
        for (int i = 0; i < 4; i++){
            for (int j = 0; j <11; j++){
                for (int z = 0; z < 96; z++){
                    calibCalPulse2->calpuls[i][j][z]  = tempCalpuls[z][j][i];
                }
            }
        }
   //-----------------------------------------------------------------------------------------
    }
}

