
// Implementation of the TrkAlarmReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TrkAlarmReader"));

/**
 * Constructor. 
 */
TrkAlarmReader::TrkAlarmReader(void): 
  TechmodelAlgorithm(PacketType::TrkAlarm, "TechmodelTrkAlarmReader") { 
  logger->debug(_T("Constructor"));
  trkAlarm = new TrkAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TrkAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TrkAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TrkAlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &trkAlarm, trkAlarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the TrkAlarm event from an input file.
 */
void TrkAlarmReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

