// Implementation of the CalibCalReader class.
 
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibCalReader"));

/**
 * Constructor. 
 */
CalibCalReader::CalibCalReader(void): 
  TechmodelAlgorithm(PacketType::CalibCal, "TechmodelCalibCalReader") { 
  logger->debug(_T("Constructor"));
  calibCal = new CalibCalEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibCalReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalibCalReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibCalReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &calibCal, calibCal->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the calibCal event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void CalibCalReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    memset(subData,  0, dataLength*sizeof(char));
    InputFile->read(subData, sizeof(subData));
    calibCal->calibCalData        = new TArrayC(dataLength, subData);
}

