/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/yoda/techmodel/VarDumpReader.cpp,v $
 * $Id: VarDumpReader.cpp,v 6.2 2006/05/30 19:10:03 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the VarDumpReader class.
 */

extern "C" {
    #include "CRC.h"
}

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.VarDumpReader"));

/**
 * Constructor. 
 */
VarDumpReader::VarDumpReader(void): 
  TechmodelAlgorithm(PacketType::VarDump, "TechmodelVarDump") { 
  VarDump = new VarDumpEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string VarDumpReader::GetVersionInfo(void) const {
  return     "$Header: /afs/ba.infn.it/user/pamela/src/CVS/yoda/techmodel/VarDumpReader.cpp,v 6.2 2006/05/30 19:10:03 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void VarDumpReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &VarDump, VarDump->Class());
}

/**
 * Unpack the VarDump event from an input file.
 */
void VarDumpReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
 
    char      subData[length];
    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  dataLength = length - 2; //the block of data
    memset(subData,  0, length*sizeof(char));
    InputFile->read(subData, sizeof(subData));
    subCRC  = CM_Compute_CRC16(0, (UINT8*)subData, dataLength);
    readCRC = (((UINT16)(subData[length - 2]<<8))&0xFF00) + (((UINT16)subData[length - 1])&0x00FF);
    
    if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for VarDump Packet ");
    /*if (subCRC != readCRC) {
        logger->error("WRONG CRC FOR VarDump PACKET. Processed anyway for CPU debugging");
    }*/

    VarDumpRecord* rec;
    VarDump->PARAMETER_STAMP = (((UINT32)subData[0]<<24)&0xFF000000) + (((UINT32)subData[1]<<16)&0x00FF0000) +  (((UINT32)subData[2]<<8)&0x0000FF00) + (((UINT32)subData[3])&0x000000FF);
    VarDump->Records->Clear();
    TClonesArray &recs = *(VarDump->Records);
    
    int offset = 4;
    int j = 0;
    while (offset < dataLength){
        rec             = new(recs[j++]) VarDumpRecord(); //add a new VarDump 
        rec->VAR_ID     = subData[offset];
        rec->VAR_VALUE  = (((UINT32)subData[1+offset]<<24)&0xFF000000) + (((UINT32)subData[2+offset]<<16)&0x00FF0000) +  (((UINT32)subData[3+offset]<<8)&0x0000FF00) + (((UINT32)subData[4+offset])&0x000000FF);
        offset = offset + 5;
    }
}

