/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/07 17:11:10 $
 * $Revision: 6.0 $
 * 
 * Implementation of the S4AlarmReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.S4AlarmReader"));

/**
 * Constructor. 
 */
S4AlarmReader::S4AlarmReader(void): 
  TechmodelAlgorithm(PacketType::S4Alarm, "S4AlarmReader") { 
  logger->debug(_T("Constructor"));
  s4Alarm = new S4AlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string S4AlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/s4AlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void S4AlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &s4Alarm, s4Alarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the S4Alarm event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void S4AlarmReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    memset(subData,  0, dataLength*sizeof(char));
    InputFile->read(subData, sizeof(subData));
    s4Alarm->s4AlarmData        = new TArrayC(dataLength, subData);
}

