/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/yoda/techmodel/LogReader.cpp,v $
 * $Id: LogReader.cpp,v 6.2 2006/05/30 19:10:03 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */

extern "C" {
#include "CRC.h"
}
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.LogReader"));

/**
 * Constructor. 
 */
LogReader::LogReader(void): 
  TechmodelAlgorithm(PacketType::Log, "TechmodelLogReader") { 
  logger->debug(_T("Constructor"));
  Log = new LogEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string LogReader::GetVersionInfo(void) const {
  return 
    "$Header: /afs/ba.infn.it/user/pamela/src/CVS/yoda/techmodel/LogReader.cpp,v 6.2 2006/05/30 19:10:03 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void LogReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &Log, Log->Class());
}

/**
 * Unpack the Log event from an input file.
 */
void LogReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){

    char      subData[length];
    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  dataLength = length - 2; //the block of data
    memset(subData,  0, length*sizeof(char));
    InputFile->read(subData, sizeof(subData));
    subCRC = CM_Compute_CRC16(0, (UINT8*)subData, dataLength);

    //took the final CRC to compare it with the previous calculated CRC of the data
    readCRC = (((UINT16)(subData[length - 2]<<8))&0xFF00) + (((UINT16)subData[length - 1])&0x00FF);

    if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for Log Packet ");
    /*if (subCRC != readCRC) {
        logger->error("WRONG CRC FOR LOG PACKET. Processed anyway for CPU debugging");
    }*/
    Log->COMPILATION_TIMESTAMP = (((UINT32)subData[0]<<24)&0xFF000000) + (((UINT32)subData[1]<<16)&0x00FF0000) +  (((UINT32)subData[2]<<8)&0x0000FF00) + (((UINT32)subData[3])&0x000000FF);

    long int offset = 4;
    int i = 0;
    LogRecord* rec;
    Log->Records->Clear();
    TClonesArray &recs = *(Log->Records);
    
    while (offset < dataLength){
        rec = new(recs[i++]) LogRecord(); //add a new Log
        rec->RECORD_OBT     = (((UINT32)subData[offset]<<24)&0xFF000000) + (((UINT32)subData[offset+1]<<16)&0x00FF0000) +  (((UINT32)subData[offset+2]<<8)&0x0000FF00) + (((UINT32)subData[offset+3])&0x000000FF);
        rec->MASKTYPE       = (((UINT8)subData[offset+4])&0xFF);
        rec->FILE_ID        = (((UINT8)subData[offset+5])&0xFF);
        rec->LINE_NO        = ((((UINT16)subData[offset+6]<<8)&0xFF00) + (((UINT16)subData[offset+7])&0x00FF));
        rec->INFO1          = (((UINT32)subData[offset+8]<<24)&0xFF000000) + (((UINT32)subData[offset+9]<<16)&0x00FF0000) +  (((UINT32)subData[offset+10]<<8)&0x0000FF00) + (((UINT32)subData[offset+11])&0x000000FF);
        offset = offset + 12;
    }
}
