/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/yoda/techmodel/Calib2_Ac1Reader.cpp,v $
 * $Id: Calib2_Ac1Reader.cpp,v 6.2 2006/05/30 19:10:02 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the Calib2_Ac1Reader class.
 */

#include <string>
#include <log4cxx/logger.h>
#include <fstream>
#include "stdio.h"
extern "C" {
    #include "CRC.h"
    #include "forroutines/anticounter/AC.h"
    extern int ACcalib(int length, unsigned char* calibpointer, struct calibstruct *calibpointer);
}

#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.Calib2_Ac1Reader"));

/**
 * Constructor. 
 */
Calib2_Ac1Reader::Calib2_Ac1Reader(void): 
  TechmodelAlgorithm(PacketType::Calib2_Ac1, "Calib2_Ac1") { 
  logger->debug(_T("Constructor"));
  calib2_Ac1 = new Calib2_Ac1Event();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string Calib2_Ac1Reader::GetVersionInfo(void) const {
  return "$Header: /afs/ba.infn.it/user/pamela/src/CVS/yoda/techmodel/Calib2_Ac1Reader.cpp,v 6.2 2006/05/30 19:10:02 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void Calib2_Ac1Reader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calib2_Ac1, calib2_Ac1->Class());
}

/**
 * Unpack the CalibAc event from an input file.
 */
void Calib2_Ac1Reader::RunEvent(int EventNumber, long int dataLength) throw (Exception){
    char   *subData = new char[dataLength];
    struct calibstruct output = {0};
    memset(subData,  0, dataLength*sizeof(char));
    InputFile->read(subData, sizeof(unsigned char)*dataLength);

    calib2_Ac1->ERROR = ACcalib(dataLength, (unsigned char*)subData, &output);
    memcpy(calib2_Ac1->header,     output.header,     sizeof(output.header));
    memcpy(calib2_Ac1->status,     output.status,     sizeof(output.status));
    memcpy(calib2_Ac1->temp,       output.temp,       sizeof(output.temp));
    memcpy(calib2_Ac1->DAC1,       output.DAC1,       sizeof(output.DAC1));
    memcpy(calib2_Ac1->DAC2,       output.DAC2,       sizeof(output.DAC2));
    memcpy(calib2_Ac1->regist,     output.regist,     sizeof(output.regist));
    memcpy(calib2_Ac1->time,       output.time,       sizeof(output.time));
    calib2_Ac1->n_tr = output.n_tr;
    memcpy(calib2_Ac1->hitmap_tr,  output.hitmap_tr,  sizeof(output.hitmap_tr));
    memcpy(calib2_Ac1->curve1,     output.curve1,     sizeof(output.curve1));
    memcpy(calib2_Ac1->curve2,     output.curve2,     sizeof(output.curve2));
    calib2_Ac1->iCRC        = output.iCRC;
    calib2_Ac1->tail        = output.tail;
    calib2_Ac1->CRC         = output.CRC;
    calib2_Ac1->CRCcheck    = output.CRCcheck;

    //delete [] subData;
  }
