/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/TechmodelPamelaRun.h,v $
 * $Id: TechmodelPamelaRun.h,v 5.1 2006/02/04 12:37:45 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the TechmodelPamelaRun class.
 */
#ifndef TECHMODEL_PAMELA_RUN_H
#define TECHMODEL_PAMELA_RUN_H

#include <iostream>
#include <fstream>

#if (__GNUC__ == 3) && (__GNUC_MINOR__ == 2)
  char* operator+( std::streampos&, char* );
#endif

#include "event/PamelaRun.h"

namespace pamela {
  /** All classes for the techmodel data files live here. */
  namespace techmodel {
    class AbstractRootTree;
    /**
     * PamelaRun class that is filled from the techmodel data file.
     */
    class TechmodelPamelaRun: public PamelaRun {
    private: 
      /**
       * The input file stream.
       */
      ifstream* InputFile;
    public: 
      TechmodelPamelaRun(std::string, std::string, bool, short);
      /**
       * Get the input file stream. 
       */
      ifstream* GetInputFile(void) { 
	return InputFile; }
    };
  }
}

#endif /* TECHMODEL_PAMELA_RUN_H */
