/** @file
 * $Author: kusanagi $
 * $Date: 2006/05/30 19:10:02 $
 * $Revision: 6.2 $
 * 
 * Implementation of the Ac1AlarmReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.Ac1AlarmReader"));

/**
 * Constructor. 
 */
Ac1AlarmReader::Ac1AlarmReader(void): 
  TechmodelAlgorithm(PacketType::Ac1Alarm, "TechmodelAc1AlarmReader") { 
  logger->debug(_T("Constructor"));
  acAlarm = new Ac1AlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string Ac1AlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/ac1AlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void Ac1AlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &acAlarm, acAlarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the Ac1Alarm event from an input file.
 */
void Ac1AlarmReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){

char     subData[dataLength];
memset(subData,  0, dataLength*sizeof(char));
InputFile->read(subData, sizeof(unsigned char)*dataLength);
acAlarm->ac1AlarmData        = new TArrayC(dataLength, subData);

}

