/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/07 17:11:09 $
 * $Revision: 6.0 $
 * 
 * Implementation of the Ac2InitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;
static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.Ac2InitReader"));

/**
 * Constructor. 
 */
Ac2InitReader::Ac2InitReader(void): 
  TechmodelAlgorithm(PacketType::Ac2Init, "Ac2InitReader") { 
  logger->debug(_T("Constructor"));
  ac2Init = new Ac2InitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string Ac2InitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/Ac2InitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void Ac2InitReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &ac2Init, ac2Init->Class());
}

/**
 * Unpack the Ac2Init event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void Ac2InitReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    memset(subData,  0, dataLength*sizeof(char));
    InputFile->read(subData, sizeof(subData));
    ac2Init->ac2InitData        = new TArrayC(dataLength, subData);
}

