*************************************************************************
*     20/1/2006 modified by elena vannuccini to code error flag
*     10/9/2005 modified by david fedele to read buffer-data
*     instead raw-data-file 
*     29/11/2005 modified by david fedele to include crc control 
*     24/06/2006 modified by elena vannuccini 
*     25/06/2006 modified by david fedele
*************************************************************************

      subroutine trkeventpkt(YODAflag,buffer,length_buffer,curpos)

      include '../common/commontracker.f'
      include '../common/common_readraw.f'
      include '../common/level0.f'

      logical ALARMS
      integer runerror          !readevent error flag
      integer*1 crctemp

*     -------------------
*     initializations
*     ---------------------------------------------------
*     the general flag YODAflag contains information 
*     about the integrity of the DSP packets. 
*     
*     If some packets are missing or the crc check fails,
*     YODAflag is asserted
*     ---------------------------------------------------
      YODAflag=1                !bad by default
      call initlevel0
      ALARMS=.false.
      npkt=0                    !#good DSP packets 
      startcrc=0  
      stopcrc=0
      crctemp=0              
*     -------------------

*     ===================================
      if(length_buffer.gt.MAXBUFFLEN)then
         print*,'trkeventpkt: buffer() size must be at least '
     $        ,length_buffer,' !!!!'
         goto 2222
      endif
*     ===================================
      
      
      do iview=1,nviews         !loop on DSPs 
         call searchtrkheader(runerror,buffer,length_buffer,curpos,
     $        startcrc)
         if(runerror.eq.1.or.runerror.eq.-1) then                  
*        --------------------------------------------------
*        no DSP packet has been found ==> go to end
*        --------------------------------------------------
            goto 2222           !go to end
         endif

         if(checkheader.ne.2) then
            print*,'>>>> ERROR <<<< (trkeventpkt)'
            print*,'>>>> CPU packet type ',!pkt_type, 
     $           ' does not match DSP packet type ',checkheader
            DAQmode_temp = ishft(iand(header(1),z'03f0'),-4)
            DSPnumber_temp = iand(header(1),z'000f')
            print*,'  -----------------------------------'
     $           ,iview
            print*,'  DSP number-----',int(DSPnumber_temp)
            print*,'  DAQ mode-------',int(DAQmode_temp)
            print*,'  -----------------------------------'
            goto 2525           !next view (==> search another DSP header)
         endif
         
         call unpackdata(runerror,buffer,length_buffer,curpos,
     $        startcrc,stopcrc,crctemp)
         if(runerror.eq.-1.or.runerror.eq.1)then 
           goto 2222            !go to end
         else if(runerror.eq.2) then
           crc_dat=2            !flag for corrupted packet
         endif

         npkt = npkt + 1
         call fillview(iview)
*--------CRC check 
         if(crc(iview).eq.0.or.crc(iview).eq.2) then !OK
*----------- ALARMS
           if(
     $          fl1(iview).ne.0.or.
     $          fl2(iview).ne.0.or.
     $          fl3(iview).ne.0.or.
     $          fl4(iview).ne.0.or.
     $          fl5(iview).ne.0.or.
     $          fl6(iview).ne.0.or.
     $          fc(iview).ne.0.or.
     $          DATAlength(iview).eq.0.or.
     $          .false.)ALARMS=.true.
         endif
         
 2525    continue
      enddo                     !end loop on views
       
 2222 continue

      if(npkt.eq.nviews)YODAflag=0
      if(YODAflag.eq.0.and.(ALARMS.eqv..false.))good0=1

      return
      end

*     **********************************************************
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     **********************************************************

      subroutine trkcalibpkt(YODAflag,buffer,length_buffer,curpos
     $     )

      include '../common/commontracker.f'
      include '../common/common_readraw.f'
      include '../common/trk_calib_parameters.f'
     
      logical ALARMs
      integer runerror          !readevent error flag
      integer*1 crctemp

*     -------------------
*     initializations
*     ---------------------------------------------------
*     the general flag YODAflag contains information 
*     about the integrity of the DSP packets. 
*     
*     If some packets are missing or the crc check fails,
*     YODAflag is asserted
*     ---------------------------------------------------
      YODAflag = 1              !bad by default
      call initcalib
      ALARMS=.false.
      npkt=0                    !#good DSP packets
      startcrc=0  
      stopcrc=0
      crctemp=0        
*     -------------------

*     ===================================
      if(length_buffer.gt.MAXBUFFLEN)then
         print*,'trkeventpkt: buffer() size must be at least '
     $        ,length_buffer,' !!!!'
         goto 2222
      endif
*     ===================================
      
      do iview=1,nplanes        !loop on views (DSP pkt)

         call searchtrkheader(runerror,buffer,length_buffer,curpos,
     $        startcrc)

         if(runerror.eq.1.or.runerror.eq.-1) then                  
            goto 2222           !end loop on views (DSP pkt)
         endif

         if(checkheader.ne.3) then
            print*,'>>>> ERROR <<<< (trkcalibpkt)'
            print*,'>>>> CPU packet type ',!pkt_type, 
     $           ' does not match DSP type ',checkheader
            DAQmode_temp = ishft(iand(header(1),z'03f0'),-4)
            DSPnumber_temp = iand(header(1),z'000f')
            print*,'  -----------------------------------'
     $           ,iview
            print*,'  DSP number-----',int(DSPnumber_temp)
            print*,'  DAQ mode-------',int(DAQmode_temp)
            print*,'  -----------------------------------'
            goto 2424           !next view (==> search another DSP header)
         endif                     
         
         call unpackcalibration(runerror,buffer,length_buffer,curpos,
     $        startcrc,stopcrc,crctemp)
         if(runerror.eq.-1.or.runerror.eq.1)then 
            goto 2222           !end
         endif
                                

         npkt = npkt + 1
         call fillview_cal(iview) !
*--------CRC check 
         if(  crc_hcal(iview).eq.0.and.
     $        crc_cal(iview,1).eq.0.and.
     $        crc_cal(iview,2).eq.0.and.
     $        crc_cal(iview,3).eq.0.and.
     $        .true.)then
*----------- ALARMS
            if(  ncalib_event(iview).ne.0.or.
     $           cal_flag(iview).ne.0.or.
     $           .false.)ALARMS=.true.
         endif         

 2424    continue
      enddo                     ! end loop on views (calibration pkt)

 2222 continue

      if(npkt.eq.nplanes)YODAflag=0
      if(YODAflag.eq.0.and.(ALARMS.eqv..false.))good0=1

      return
      end

*     **********************************************************
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     **********************************************************

      subroutine searchtrkheader(runerror,buffer,length_buffer,
     $     curpos,startcrc)
C.............................................................
C     Search for a valid tracker DSP header (=>one view) 
C     and return the type of header
C.............................................................

      include '../common/commontracker.f'
      include '../common/common_readraw.f'

      integer runerror          !readevent error flag

c--------------------------------------------------
c     N.B.13 bit packing is done for each DSP header+datablock, 
C     so each DSP 13 bit 
c     first word starts at the beginnig of a 16 bit word
c--------------------------------------------------

 9100 continue
      runerror=0                !error flag initialization
      checkheader=0

c--------------------------------------------------
c     looks for a DSP header beginning 
C     (a word beginning with 1110)
c--------------------------------------------------
      
      call findstart(runerror,buffer,length_buffer,curpos)
            
      if(runerror.eq.1) goto 200 !end
      if(runerror.eq.-1)goto 200 !end
c--------------------------------------------------
c     the first word could be a DSP header first word: 
C     reads 13 8-bit words and 
c     writes them in 16 13-bit words to check for all 
C     DSP header features
c--------------------------------------------------
         
      call hunpacker(header,runerror,buffer,length_buffer,curpos,
     $     startcrc)
            
      if(runerror.eq.1) goto 200 !end
      if(runerror.eq.-1)goto 200 !end
c--------------------------------------------------
c     extracts and controls header:
c--------------------------------------------------
C     last header word must be:
c     |0001|1100|0000|0000| for acquisition
c     |0001|1111|1111|1111| for calibration
c--------------------------------------------------
      if(iand(header(16),z'ffff').eq.z'1c00') then 
         checkheader=2          ! event packet
      elseif(iand(header(16),z'ffff').eq.z'1fff') then 
         checkheader=3          ! calibration packet
      else
         checkheader=1          ! not a valid DSP header
      endif
c--------------------------------------------------
c     first header word must be:  
c     |0001|110x|xxxx|xxxx|
c--------------------------------------------------
      if(iand(header(1),z'fe00').ne.z'1c00') 
     $     checkheader=1        !not a valid DSP header
c--------------------------------------------------
c     intermediate header words must be:  
c     |0001|010x|xxxx|xxxx|
c--------------------------------------------------
      do i=2,15    
         if(iand(header(i),z'fc00').ne.z'1400') 
     $        checkheader=1     !not a valid DSP header
      enddo
c--------------------------------------------------
c     if checkheader = 1 
c     then this is not a DSP header (or some 
c     noise lurks around) so go a word ahead and 
c     try again
c--------------------------------------------------
      if(checkheader.eq.1) then   
         curpos=curpos-(13*2)+1 !goes back 13 words, then half 16 bit word ahead 
         goto 9100
      endif
      
 200  continue
      end

*     **********************************************************
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     **********************************************************

      subroutine unpackcalibration(runerror,buffer,length_buffer,curpos,
     $     startcrc,stopcrc,crctemp)

*.............................................................
*     decode calibration data
*     header + data(PED SIG BAD) + trailer
*............................................................
      include '../common/commontracker.f'
      include '../common/common_readraw.f'

      integer*1 crctemp
      integer*1 crc_trail
 
      integer runerror          !readevent error flag
      integer*2 templ(nstrips_ladder) 
      real*4 tempf(nstrips_ladder)
      


 12   format(z4)

*-----------------------------------------------------------
*     HEADER
*     (N.B. during test 2003 the header of calibration packets
*     was only partially filled)
*
*     the following is the final calibration header
*-----------------------------------------------------------
      DAQmode_cal = ishft(iand(header(1),z'03f0'),-4)
      DSPnumber_cal = iand(header(1),z'000f')
      dataword = ior(ishft(iand(header(2),z'03ff')
     $     ,10),iand(header(3),z'03ff'))
      calibrationnumber = iand(header(4),z'03ff')
      nused_event = iand(header(5),z'03ff')
      ped_1 = iand(header(6),z'03ff')
      ped_2 = iand(header(7),z'03ff')
      ped_3 = iand(header(8),z'03ff')
      ped_1 = ped_1 * 4
      ped_2 = ped_2 * 4
      ped_3 = ped_3 * 4
      sig_1 = iand(header(9),z'03ff')
      sig_2 = iand(header(10),z'03ff')
      sig_3 = iand(header(11),z'03ff')
      nbad_1 = iand(header(12),z'03ff')
      nbad_2 = iand(header(13),z'03ff')
      nbad_3 = iand(header(14),z'03ff')
      ff = ishft(iand(header(15),z'0300'),-8)
      checksum_cal = iand(header(15),z'00ff') 
c-----------------------------------------------------------
c     the checksum is a 8-bit word calculated as the 
c     XOR of the 16-bit data words,
c     hence the XOR between the two halfs
C----------------------------------------------------------

      runerror=0
c$$$      
c$$$      print*,'-----------------------------------'
c$$$      print*,'unpackcalibration: readtrailer  --- ',
c$$$*     $     trailer,runerror,buffer,length_buffer,curpos,
c$$$     $     startcrc,stopcrc,crctemp   
c$$$      print*,'-----------------------------------'
      call readtrailer(trailer,runerror,buffer,length_buffer,curpos,
     $     startcrc,stopcrc,crctemp) 
      
      crc_trail=iand(trailer(3),z'00ff')
      
c$$$      print *,'@@@@@@@@@@@@@ ',crctemp,crc_trail

      if (crctemp.eq.crc_trail)then
         crc_hcalib=0
      else
         crc_hcalib=1
      endif
      
      do il=1,3                 !loop on ladders
         startcrc=curpos
         call readped(tempf,runerror,buffer,length_buffer,curpos)
         do is=1,nstrips_ladder
            iss=is+nstrips_ladder*(il-1)
            DSPped_o(DSPnumber_cal,iss)=tempf(is)
         enddo
         
         call readsig(tempf,runerror,buffer,length_buffer,curpos)
         do is=1,nstrips_ladder
            iss=is+nstrips_ladder*(il-1)
            DSPsig_o(DSPnumber_cal,iss)=tempf(is)
         enddo
         
         call readbad(templ,runerror,buffer,length_buffer,curpos)
         do is=1,nstrips_ladder
            iss=is+nstrips_ladder*(il-1)
            DSPbad_o(DSPnumber_cal,iss)=templ(is)
         enddo
         
 11      format(i1,'   ',z4)
         
         call readtrailer(trailer,runerror,buffer,length_buffer,curpos,
     $        startcrc,stopcrc,crctemp)

         crc_trail=iand(trailer(3),z'00ff')
         
         if (crctemp.eq.crc_trail)then
           crc_calib(il)=0
         else
           crc_calib(il)=1
         endif
           
      enddo                     !end loop on ladders
      
      return
      end

*     **********************************************************
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     **********************************************************

      subroutine unpackdata(runerror,buffer,length_buffer,curpos,
     $     startcrc,stopcrc,crctemp)

*.............................................................
*     decode event data
*     header + data + trailer
*............................................................

      include '../common/commontracker.f'
      include '../common/common_readraw.f'
      include '../common/level0.f'

      integer*1 crctemp
      integer*1 crcdat

      integer runerror          !readevent error flag
c      integer l_tra

      integer bid1_dat,bid2_dat,bid3_dat,bid4_dat,bid5_dat,bid6_dat
     $     ,bid7_dat,bid_dat_sum
      
      
 12   format(z4)

*-----------------------------------------------------------
*     HEADER
*-----------------------------------------------------------

      DAQmode_dat = ishft(iand(header(1),z'03f0'),-4)
      DSPnumber_dat = iand(header(1),z'000f')
C     ------------------------------------------------------
c     words 2 and 3 give the number of transmitted 16-bit
c     words ( 13 header words + data )
c     NB: data are packed from 13-bit to 16-bit words, 
c     so the stream is complited with zeros in order to have 
c     a number of bits multiple of 16
C     ------------------------------------------------------
      l_tra = ior(ishft(iand(header(2),z'03ff')
     $     ,10),iand(header(3),z'03ff'))
      l_tra=l_tra-13            
C     ------------------------------------------------------
      eventn_dat = ior(ishft(iand(header(4),z'03ff')
     $     ,10),iand(header(5),z'03ff'))
      nclust_dat = ishft(iand(header(6),z'0380'),-7)
      cutc_dat = ishft(iand(header(6),z'0070'),-4)
      cutcl_dat = iand(header(6),z'000f')
      addrcluster_dat(1) = iand(header(7),z'03ff')
      signcluster_dat(1) = iand(header(8),z'03ff')
      addrcluster_dat(2) = iand(header(9),z'03ff')
      signcluster_dat(2) = iand(header(10),z'03ff')
      addrcluster_dat(3) = iand(header(11),z'03ff')
      signcluster_dat(3) = iand(header(12),z'03ff')
      fc_dat = ishft(iand(header(13),z'0300'),-8)
      compressiontime_dat = iand(header(13),z'00ff')
c      fl5_dat = ishft(iand(header(14),z'0300'),-8)
c      fl4_dat = ishft(iand(header(14),z'0300'),-6)
c      fl3_dat = ishft(iand(header(14),z'0300'),-4)
c      fl2_dat = ishft(iand(header(14),z'0300'),-2)
c      fl1_dat = iand(header(14),z'0300')
c      fl6_dat = ishft(iand(header(15),z'0300'),-8)
      fl5_dat = iand(ishft(header(14),-8),z'0003')
      fl4_dat = iand(ishft(header(14),-6),z'0003')
      fl3_dat = iand(ishft(header(14),-4),z'0003')
      fl2_dat = iand(ishft(header(14),-2),z'0003')
      fl1_dat = iand(header(14),z'0003')
      fl6_dat = iand(ishft(header(15),-8),z'0003')
      checksum_dat = iand(header(15),z'00ff') 

c-----------------------------------------------------------
c     the cheacksum is a 8-bit word calculated as the 
c     XOR of the 16-bit data words,
c     hence the XOR between the two halfs
C----------------------------------------------------------
      runerror=0
      nqualcosa=0
      if(l_tra.eq.0)then 
         goto 18                !empty buffer
      endif
      
      if(l_tra.gt.MAXBUFFLEN .or.(curpos+l_tra-1).ge.MAXBUFFLEN )then
         print*,'unpackdata: '
     $        ,'tracker buffer length l_tra ',l_tra
     $        ,' exceeds tracker buffer dimensions '
         print*,'(packet corrupted)'
cc         runerror=1
         runerror=2
         goto 50
      endif
      call dunpacker(l_tra,b_tra,runerror,buffer,length_buffer,curpos)
      if(runerror.eq.1.or.runerror.eq.-1) then
         goto 50                !go to end
      endif

      nqualcosa = (real(l_tra))/13*16
      xx = b_tra(nqualcosa)
      if (xx.eq.0) nqualcosa=nqualcosa -1
      
 18   datalength_dat= nqualcosa
 11   format(i1,'   ',z4)
     
      call readtrailer(trailer,runerror,buffer,length_buffer,curpos,
     $     startcrc,stopcrc,crctemp)
      
***************************************************************      
*                      TRAILER                                *
***************************************************************

      pnum_dat=ishft(iand(trailer(1),z'f000'),-12)
      cmdnum_dat=ishft(iand(trailer(1),z'0f00'),-8)
      bid1_dat=ishft(iand(trailer(1),z'00c0'),-6)
      bid2_dat=ishft(iand(trailer(1),z'0030'),-4)
      bid3_dat=ishft(iand(trailer(1),z'000c'),-2)
      bid4_dat=iand(trailer(1),z'0003')
      bid5_dat=ishft(iand(trailer(2),z'c000'),-14)
      bid6_dat=ishft(iand(trailer(2),z'3000'),-12)
      bid7_dat=ishft(iand(trailer(2),z'0c00'),-10)
      alarm_dat=ishft(iand(trailer(2),z'0300'),-8)   
      aswr_dat=ior(ishft(iand(trailer(2),z'00ff'),8)
     $      ,ishft(iand(trailer(3),z'ff00'),-8))
      crcdat=iand(trailer(3),z'00ff')

c$$$      print*,'######################',crcdat,crctemp


      if(crcdat.eq.crctemp)then
         crc_dat=0
      else
         crc_dat=1
      endif

      bid_dat_sum = (bid1_dat + bid2_dat + bid3_dat + bid4_dat +
     &     bid5_dat + bid6_dat + bid7_dat) 

      bid_dat = bid_dat_sum/7
      
 50   return
      end

*     **********************************************************
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     **********************************************************

      subroutine initlevel0

      include '../common/commontracker.f'
      include '../common/level0.f'

      good0=0
      TOTDATAlength = 0

      do i=1, nviews
         
         DAQmode(i) = 0
         DSPnumber(i) = 0
         eventn(i) = 0
         nclust(i) = 0
         cutc(i) = 0
         cutcl(i) = 0
         addrcluster(i,1) = 0
         signcluster(i,1) = 0
         addrcluster(i,2) = 0
         signcluster(i,2) = 0
         addrcluster(i,3) = 0
         signcluster(i,3) = 0
         fc(i) = 0
         compressiontime(i) = 0
         fl5(i) = 0
         fl4(i) = 0 
         fl3(i) = 0  
         fl2(i) = 0  
         fl1(i) = 0  
         fl6(i) = 0  
         checksum(i) = 0
         DATAlength(i) = 0
         pnum(i)= 0
         cmdnum(i)= 0
         bid(i) = 1 
         alarm(i)= 0
         aswr(i) = 0
         crc(i)=0

      enddo


      return
      end

*     **********************************************************
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     **********************************************************

      subroutine fillview(i)
c     -----------------------------------------------------
c     fill variables related to view i
c     which will be stored in the level0 nt-ple
c     at the end of loop on views
c     ----------------------------------------------------

      include '../common/commontracker.f'
      include '../common/level0.f'
      include '../common/common_readraw.f'


      DAQmode(i) = DAQmode_dat
      DSPnumber(i) =  DSPnumber_dat
      eventn(i) = eventn_dat
      nclust(i) = nclust_dat
      cutc(i) = cutc_dat
      cutcl(i) = cutcl_dat
      addrcluster(i,1) = addrcluster_dat(1)
      signcluster(i,1) = signcluster_dat(1)
      addrcluster(i,2) = addrcluster_dat(2)
      signcluster(i,2) = signcluster_dat(2)
      addrcluster(i,3) = addrcluster_dat(3)
      signcluster(i,3) = signcluster_dat(3)
      fc(i) = fc_dat
      compressiontime(i) = compressiontime_dat
      fl5(i) = fl5_dat
      fl4(i) = fl4_dat
      fl3(i) = fl3_dat  
      fl2(i) = fl2_dat
      fl1(i) = fl1_dat
      fl6(i) = fl6_dat
      checksum(i) = checksum_dat
      DATAlength(i) = datalength_dat
      crc(i) = crc_dat

c    -----------------------------------------------------------------------
c     filling TRAILER variables
c     ----------------------------------------------------------------------

      pnum(i)= pnum_dat
      cmdnum(i)= cmdnum_dat
      bid(i) = bid_dat 
      alarm(i)= alarm_dat
      aswr(i) = aswr_dat

      do idat=1,datalength_dat  
         id =  TOTDATAlength + idat
         datatracker(id) = b_tra(idat)
      enddo
      TOTDATAlength = TOTDATAlength + datalength_dat

      return
      end

*     **********************************************************
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     **********************************************************

      subroutine fillview_cal(i)
c     -----------------------------------------------------
c     fill variables related to view i
c     which will be stored in the calibration nt-ple
c     at the end of loop on views
c     ----------------------------------------------------

      include '../common/commontracker.f'
      include '../common/trk_calib_parameters.f'
      include '../common/common_readraw.f'

      DAQmode(i)     = DAQmode_cal
      DSPnumber(i)   = DSPnumber_cal
      calibnumber(i) = calibrationnumber
      ncalib_event(i)= nused_event
      ped_l1(i)      = ped_1
      ped_l2(i)      = ped_2
      ped_l3(i)      = ped_3
      sig_l1(i)      = sig_1
      sig_l2(i)      = sig_2
      sig_l3(i)      = sig_3
      nbad_l1(i)     = nbad_1
      nbad_l2(i)     = nbad_2
      nbad_l3(i)     = nbad_3
      cal_flag(i)    = ff

      do is=1,nstrips_view
         DSPbad_par(i,is) = DSPbad_o(DSPnumber_cal,is)
         DSPped_par(i,is) = DSPped_o(DSPnumber_cal,is)
         DSPsig_par(i,is) = DSPsig_o(DSPnumber_cal,is)
      enddo

      crc_hcal(i)    = crc_hcalib      
      crc_cal(i,1)   = crc_calib(1)
      crc_cal(i,2)   = crc_calib(2)
      crc_cal(i,3)   = crc_calib(3)
      
      return
      end

*     **********************************************************
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     *                                                        *
*     **********************************************************

      subroutine initcalib
      include '../common/commontracker.f'
      include '../common/trk_calib_parameters.f'

      good0=0

      do i=1,nplanes

         DAQmode(i)     = 0
         DSPnumber(i)   = 0
         calibnumber(i) = 0
         ncalib_event(i)= 0
         ped_l1(i)      = 0
         ped_l2(i)      = 0
         ped_l3(i)      = 0
         sig_l1(i)      = 0
         sig_l2(i)      = 0
         sig_l3(i)      = 0
         nbad_l1(i)     = 0
         nbad_l2(i)     = 0
         nbad_l3(i)     = 0
         cal_flag(i)    = 0
         
         do is=1,nstrips_view
            DSPbad_par(i,is) = 0
            DSPped_par(i,is) = 0
            DSPsig_par(i,is) = 0
         enddo
         crc_hcal(i)    = 0
         crc_cal(i,1)   = 0
         crc_cal(i,2)   = 0
         crc_cal(i,3)   = 0
      enddo

      return
      end
