/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/07 17:11:10 $
 * $Revision: 6.0 $
 * 
 * Implementation of the TrgAlarmReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;
static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TrgAlarmReader"));

/**
 * Constructor. 
 */
TrgAlarmReader::TrgAlarmReader(void): 
  TechmodelAlgorithm(PacketType::TrgAlarm, "TechmodelTrgAlarmReader") { 
  logger->debug(_T("Constructor"));
  trgAlarm = new TrgAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TrgAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TrgAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TrgAlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &trgAlarm, trgAlarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the TrgAlarm event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void TrgAlarmReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    memset(subData,  0, dataLength*sizeof(char));
    InputFile->read(subData, sizeof(subData));
    trgAlarm->trgAlarmData        = new TArrayC(dataLength, subData);
}

