    /** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/yoda/techmodel/PhysicsReader.cpp,v $
 * $Id: PhysicsReader.cpp,v 6.0 2006/02/07 17:11:10 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"


using namespace pamela;
using namespace pamela::techmodel;
using namespace pamela::tracker;
using namespace pamela::anticounter;
using namespace pamela::calorimeter;
using namespace pamela::neutron;
using namespace pamela::S4;
using namespace pamela::tof;
using namespace pamela::trigger;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.PhysicsReader"));

/**
 * Constructor. 
 */
PhysicsReader::PhysicsReader(void): 
    TechmodelAlgorithm(PacketType::Physics, "TechmodelPhysicsReader") { 
    logger->debug(_T("Constructor"));
    trackerReader     = new TrackerReader;
    anticounterReader = new AnticounterReader;
    calorimeterReader = new CalorimeterReader;
    neutronReader     = new NeutronDetectorReader;
    s4Reader          = new S4Reader;
    tofReader         = new TofReader;
    triggerReader     = new TriggerReader;
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string PhysicsReader::GetVersionInfo(void) const {
  return 
    "$Header: /afs/ba.infn.it/user/pamela/src/CVS/yoda/techmodel/PhysicsReader.cpp,v 6.0 2006/02/07 17:11:10 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void PhysicsReader::Init(PamelaRun *run) {
    SetInputStream(run);
    trackerReader->Init(run);
    anticounterReader->Init(run);
    calorimeterReader->Init(run);
    neutronReader->Init(run);
    s4Reader->Init(run);
    tofReader->Init(run);
    triggerReader->Init(run);
  //run->WriteSubPacket(this, &physicsEvent, physicsEvent->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the Physics event from an input file.
 */
void PhysicsReader::RunEvent(int EventNumber, long int dataLenght) throw (Exception){
    char *subData = new char[dataLenght];
    InputFile->read(subData, sizeof(unsigned char)*dataLenght);

    /*-----------------*/
    //passo packetData a tutti i reader dei vari rivelatori
    trackerReader->RunEvent(EventNumber, subData, dataLenght);
    anticounterReader->RunEvent(EventNumber, subData, dataLenght);
    calorimeterReader->RunEvent(EventNumber, subData, dataLenght);
    neutronReader->RunEvent(EventNumber, subData, dataLenght);
    s4Reader->RunEvent(EventNumber, subData, dataLenght);
    tofReader->RunEvent(EventNumber, subData, dataLenght);
    triggerReader->RunEvent(EventNumber, subData, dataLenght);
    /*-----------------*/
    delete [] subData;
}

