
// Implementation of the CalAlarmReader class.
 
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalAlarmReader"));

/**
 * Constructor. 
 */
CalAlarmReader::CalAlarmReader(void): 
  TechmodelAlgorithm(PacketType::CalAlarm, "TechmodelCalAlarmReader") { 
  logger->debug(_T("Constructor"));
  calAlarm = new CalAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalAlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &calAlarm, calAlarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the CalAlarm event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void CalAlarmReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    InputFile->read(subData, sizeof(subData));
    calAlarm->calAlarmData        = new TArrayC(dataLength, subData);
}

