/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/CalibTofReader.cpp,v $
 * $Id: CalibTofReader.cpp,v 5.1 2006/02/04 12:37:44 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/CalibTofEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibTofReader"));

/**
 * Constructor. 
 */
CalibTofReader::CalibTofReader(void): 
  TechmodelAlgorithm(PacketType::Log, "TechmodelCalibTofReader") { 
  logger->debug(_T("Constructor"));
  CalibTof = new CalibTofEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTofReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/CalibTofReader.cpp,v 5.1 2006/02/04 12:37:44 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTofReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &CalibTof, CalibTof->Class());
}

/**
 * Unpack the CalibTof event from an input file.
 */
void CalibTofReader::RunEvent(int EventNumber, long int length) throw (Exception){
    
    
}

