/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/07 10:43:06 $
 * $Revision: 5.3 $
 * 
 * Implementation of the CalibTrailerReader class.
 */ 

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibTrk1Reader"));

/**
 * Constructor. 
 */
CalibTrailerReader::CalibTrailerReader(void): 
  TechmodelAlgorithm(PacketType::CalibTrailer, "TechmodelCalibTrailerReader") { 
  logger->debug(_T("Constructor"));
  calibTrailer = new CalibTrailerEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTrailerReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalibTrailerReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTrailerReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calibTrailer, calibTrailer->Class());
}

/**
 * Unpack the CalibTrailer event from an input file.
 */
void CalibTrailerReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  length = dataLength - 2; //the block of data

    InputFile->read(subData, sizeof(subData));
    subCRC  = CM_Compute_CRC16(0, (UINT8*)subData, length);
    readCRC = (((UINT16)(subData[dataLength - 2]<<8))&0xFF00) + (((UINT16)subData[dataLength - 1])&0x00FF);

    if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for CalibTrailer Packet ");
}

