/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/07 10:43:06 $
 * $Revision: 5.3 $
 * 
 * Implementation of the InitTrailerReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.InitTrailerReader"));

/**
 * Constructor. 
 */
InitTrailerReader::InitTrailerReader(void): 
  TechmodelAlgorithm(PacketType::InitTrailer, "TechmodelInitTrailerReader") { 
  logger->debug(_T("Constructor"));
  initTrailer = new InitTrailerEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string InitTrailerReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/InitTrailerReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void InitTrailerReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &initTrailer, initTrailer->Class());
}

/**
 * Unpack the InitTrailer event from an input file.
 */
void InitTrailerReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  length = dataLength - 2; //the block of data

    InputFile->read(subData, sizeof(subData));
    subCRC  = CM_Compute_CRC16(0, (UINT8*)subData, length);
    readCRC = (((UINT16)(subData[dataLength - 2]<<8))&0xFF00) + (((UINT16)subData[dataLength - 1])&0x00FF);

    if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for InitTrailer Packet ");
}

