/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/Calib1_Ac2Reader.cpp,v $
 * $Id: Calib1_Ac2Reader.cpp,v 5.1 2006/02/04 12:37:44 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the Calib1_Ac2Reader class.
 */

#include <string>
#include <log4cxx/logger.h>
#include <fstream>
#include "stdio.h"
extern "C" {
    #include "CRC.h"
    #include "forroutines/anticounter/AC.h"
    extern int ACcalib(int length, unsigned char* calibpointer, struct calibstruct* calibpointer);
}

#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.Calib1_Ac2Reader"));

/**
 * Constructor. 
 */
Calib1_Ac2Reader::Calib1_Ac2Reader(void): 
  TechmodelAlgorithm(PacketType::Calib1_Ac2, "Calib1_Ac2") { 
  logger->debug(_T("Constructor"));
  calib1_Ac2 = new Calib1_Ac2Event();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string Calib1_Ac2Reader::GetVersionInfo(void) const {
  return "$Header: /home/cvsmanager/yoda/techmodel/Calib1_Ac2Reader.cpp,v 5.1 2006/02/04 12:37:44 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void Calib1_Ac2Reader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calib1_Ac2, calib1_Ac2->Class());
}

/**
 * Unpack the Calib1_Ac2Reader event from an input file.
 */
void Calib1_Ac2Reader::RunEvent(int EventNumber, long int dataLength) throw (Exception){
/*

*/    

    //delete [] subData;
}

