
// Implementation of the PhysEndRunReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.PhysEndRunReader"));

/**
 * Constructor. 
 */
PhysEndRunReader::PhysEndRunReader(void): 
  TechmodelAlgorithm(PacketType::PhysEndRun, "TechmodelPhysEndRunReader") { 
  logger->debug(_T("Constructor"));
  physEndRun = new PhysEndRunEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string PhysEndRunReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/PhysEndRunReader.cpp,v 4.5 2005/08/29 09:29:03 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void PhysEndRunReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &physEndRun, physEndRun->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the PhysEndRun event from an input file.
 */

void PhysEndRunReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    char subData[length];
    UINT16    subCRC;      //CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  dataLength;
    long int  tbInitPos;

    //int numRecords = ((length - 2)/6);
    dataLength = length - (long int)2;    
    tbInitPos = dataLength - 19; // 19 is the length of th TB
    //physEndRun->CALO_ENDRUN[];
    //physEndRun->TB_ENDRUN;
    
    InputFile->read(subData, sizeof(unsigned char)*length);
    subCRC = CM_Compute_CRC16(0, (UINT8*)subData, dataLength);
    readCRC = (((UINT16)(subData[length - 2]<<8))&0xFF00) + (((UINT16)subData[length - 1])&0x00FF);
    
    if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for PhysEndRun Packet ");
    /*if (subCRC != readCRC) {
        logger->error(" Wrong CRC for PhysEndRun Packet but I process it anyway");
    }*/
    //--------------- CALO SECTION------------------------------------
    long int offset = 0;
    int j = 0;
    //physEndRun->CALO_ENDRUN.
    while(offset < tbInitPos){
        physEndRun->CALO_ENDRUN[j].CALO_BOARD_ID_HK     = (((UINT8)subData[offset])&0x1F);
        physEndRun->CALO_ENDRUN[j].CALO_BOARD_STATUS_HK = ((UINT8)subData[offset+1]);
        //subData[offset+2--->3] is a fixed word = 0x23
        //If this bit is ? the subsequent CALO_HK are not valid
        if (!(physEndRun->CALO_ENDRUN[j].CALO_BOARD_STATUS_HK & 0x02)) {
            for(int k = 0; k < 11 ; k++){
                physEndRun->CALO_ENDRUN[j].CALO_HK0[k] = (((UINT16)(subData[offset+3+k]<<8))&0xFF00) + (((UINT16)subData[offset+4+k])&0x00FF);
                physEndRun->CALO_ENDRUN[j].CALO_HK1[k] = (((UINT16)(subData[offset+14+k]<<8))&0xFF00) + (((UINT16)subData[offset+15+k])&0x00FF);
            }
            offset = offset + 50; //CALO_BOARD_ID_HK + CALO_BOARD_STATUS_HK + 2*CALO_HKx + CRC (2Bytes)
        } else offset = offset + 4; //CALO_BOARD_ID_HK + CALO_BOARD_STATUS_HK + CRC (2Bytes)
        //subData[offset+(3+k)--->(15+k)] have a CRC(what?) in subData[offset+ 23--->24]

        for(int k = 0; k < 7 ; k++){
            physEndRun->CALO_ENDRUN[j].CALO_BOARD_ID_REG     = ((UINT8)(subData[offset])&0x1F);
            physEndRun->CALO_ENDRUN[j].CALO_BOARD_STATUS_REG = (UINT8)(subData[offset+1]);
            //subData[offset+2--->3] is a fixed word = 0x2
            physEndRun->CALO_ENDRUN[j].CALO_REG[k] = (((UINT16)(subData[offset+4]<<8))&0xFF00) + (((UINT16)subData[offset+5])&0x00FF);
            //subData[offset+ 0--->5] have a CRC(what?) in subData[offset+ 6--->7]
            offset = offset + 8; //CALO_BOARD_ID_REG + CALO_BOARD_STATUS_REG + CALO_REG + CRC(2Byte) 
        }
        j++;
    }
    
    //--------------- TB SECTION------------------------------------
    physEndRun->TB_ENDRUN.TB_ALARM_MASK   = (((UINT16)(subData[offset]<<8))&0xFF00) + (((UINT16)subData[offset + 1])&0x00FF);
    //subData[offset+ 0--->1] have a CRC(what?) in subData[offset+2]
    physEndRun->TB_ENDRUN.TB_PMT_MASK_S3  = ((((UINT16)(subData[offset+2]))<<4)&0x0FF0) + (((UINT16)subData[offset + 3]>>4)&0x000F);
    physEndRun->TB_ENDRUN.TB_PMT_MASK_S2  = ((((UINT8)(subData[offset+3]))<<4)&0xF0) + (((UINT8)subData[offset + 4]>>4)&0x0F);
    physEndRun->TB_ENDRUN.TB_PMT_MASK_S12 = ((((UINT16)(subData[offset+4]))<<8)&0x0F00) + (((UINT16)subData[offset + 5])&0x00FF);
    physEndRun->TB_ENDRUN.TB_PMT_MASK_S11 = ((((UINT16)(subData[offset+6]))<<8)&0xFF00) + (((UINT16)subData[offset + 7])&0x00FF);
    //subData[offset+ 3--->8] have a CRC(what?) in subData[offset+9]
    physEndRun->TB_ENDRUN.TB_CALO_MASK    = ((UINT8)subData[offset+10])>>5;
    physEndRun->TB_ENDRUN.TB_S4_MASK      = (((UINT8)subData[offset+10])>>1)&0x0F;
    //subData[tbInitPos+9] have a CRC(what?) in subData[tbInitPos+11]
    physEndRun->TB_ENDRUN.TB_BUSY_MASK    = (((UINT32)subData[offset+12]<<16)&0x00FF0000) +  (((UINT32)subData[offset+13]<<8)&0x0000FF00) + (((UINT32)subData[offset+14])&0x000000FF);
    //subData[tbInitPos+ 12--->14] have a CRC(what?) in subData[tbInitPos+15]
    physEndRun->TB_ENDRUN.TB_CALIB_FLAG   = ((UINT8)subData[offset+16])>>7;
    physEndRun->TB_ENDRUN.TB_CALO_TRIG    = ((UINT8)subData[offset+16])>>6; 
    physEndRun->TB_ENDRUN.TB_S4_TRIG      = ((UINT8)subData[offset+16])>>5; 
    physEndRun->TB_ENDRUN.TB_TOF_TRIG     = (UINT8)(subData[offset+16]<<3) + (UINT8)(subData[offset+17]>>6);
    //subData[tbInitPos+ 16--->17] have a CRC(what?) in subData[tbInitPos+18]
}

