
// Implementation of the CalibHeaderReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/CalibHeaderEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibHeaderReader"));

/**
 * Constructor. 
 */
CalibHeaderReader::CalibHeaderReader(void): 
  TechmodelAlgorithm(PacketType::CalibHeader, "TechmodelCalibHeaderReader") { 
  logger->debug(_T("Constructor"));
  calibHeader = new CalibHeaderEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibHeaderReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/CalibHeaderReader.cpp,v 4.4 2005/05/28 10:44:11 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibHeaderReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calibHeader, calibHeader->Class());
}

/**
 * Unpack the CalibHeader event from an input file.
 */
void CalibHeaderReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

