
// Implementation of the TrkAlarmReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TrkAlarmReader"));

/**
 * Constructor. 
 */
TrkAlarmReader::TrkAlarmReader(void): 
  TechmodelAlgorithm(PacketType::TrkAlarm, "TechmodelTrkAlarmReader") { 
  logger->debug(_T("Constructor"));
  trkAlarm = new TrkAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TrkAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TrkAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TrkAlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &trkAlarm, trkAlarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the TrkAlarm event from an input file.
 */
void TrkAlarmReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    char        subData[length];
    InputFile->read(subData, sizeof(subData));

    trkAlarm->TrigMask      = (subData[0]&0xc0) >> 6;
    trkAlarm->DSPMask       = (subData[0]&0x3f);
    

    trkAlarm->FlashShutdown = (subData[1]&0x80) >> 7;
    trkAlarm->FlashOn       = (subData[1]&0x40) >> 6;
    trkAlarm->DSPBusy       = (subData[1]&0x3f);
    
    trkAlarm->FlashUpset    = (subData[2]&0x80) >> 7;
    trkAlarm->FlashData     = (subData[2]&0x40) >> 6;
    trkAlarm->DSPSoft       = (subData[2]&0x3f);
    
    trkAlarm->InterCheck    = (subData[3]&0x80) >> 7;
    trkAlarm->FinalCheck    = (subData[3]&0x40) >> 6;
    trkAlarm->CmdIDMA       = (subData[3]&0x3f);
    
    trkAlarm->UnknownCmd    = (subData[4]&0x80) >> 7;
    trkAlarm->CmdDuringTrig = (subData[4]&0x40) >> 6;
    trkAlarm->TrigIDMA      = (subData[4]&0x3f);

    trkAlarm->PNum          = (subData[5]&0xf0) >> 4;
    trkAlarm->CmdNum        = (subData[5]&0x0f);
    
    for(int i=0 ; i<4 ; i++){       
	trkAlarm->BID[i]    = (subData[6]&(0x03<<i*2)) >> i*2;
    };

    for(int i=1 ; i<4 ; i++){       
	trkAlarm->BID[3+i]  = (subData[7]&(0x03<<i*2)) >> i*2;
    };

    trkAlarm->ALARM[0]      = (subData[7]&0x02) >> 1;
    trkAlarm->ALARM[1]      = (subData[7]&0x01);
    
    trkAlarm->Aswr          = (subData[8]&0xff) << 8;
    trkAlarm->Aswr          = trkAlarm->Aswr | (subData[9]&0xff);
}

