/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/PscuReader.cpp,v $
 * $Id: PscuReader.cpp,v 4.4 2005/05/28 10:44:11 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the OrbitalReader class.
 */

#include <string>
#include <log4cxx/logger.h>

#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static LoggerPtr logger = Logger::getLogger(_T("pamela.techmodel.PscuReader"));

/**
 * Constructor. 
 */
PscuReader::PscuReader(void): 
  TechmodelAlgorithm(PacketType::Pscu, "TechmodelPscuReader") { 
  logger->debug(_T("Constructor"));
  Pscu = new PscuEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string PscuReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/PscuReader.cpp,v 4.4 2005/05/28 10:44:11 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void PscuReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &Pscu, Pscu->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the orbital event from an input file.
 */
void PscuReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
  // First step: unpack the event into the event class.
}
