/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/ArrDumpReader.cpp,v $
 * $Id: ArrDumpReader.cpp,v 4.5 2005/08/29 09:23:39 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the ArrDumpReader class.
 */

#include <string>
#include <log4cxx/logger.h>
#include <fstream>
#include "stdio.h"
extern "C" {
    #include "CRC.h"
}

#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.ArrDumpReader"));

/**
 * Constructor. 
 */
ArrDumpReader::ArrDumpReader(void): 
  TechmodelAlgorithm(PacketType::ArrDump, "TechmodelArrDump") { 
  logger->debug(_T("Constructor"));
  ArrDump = new ArrDumpEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string ArrDumpReader::GetVersionInfo(void) const {
  return "$Header: /home/cvsmanager/yoda/techmodel/ArrDumpReader.cpp,v 4.5 2005/08/29 09:23:39 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void ArrDumpReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &ArrDump, ArrDump->Class());
}

/**
 * Unpack the ArrDump event from an input file.
 */
void ArrDumpReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
  
    char      subData[length];
    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;      //CRC read from the end of the subpacket
    long int  dataLength = length - 2;  //the block of data
  
    InputFile->read(subData, sizeof(subData));
    subCRC  = CM_Compute_CRC16(0, (UINT8*)subData, dataLength);
    readCRC = (((UINT16)(subData[length - 2]<<8))&0xFF00) + (((UINT16)subData[length - 1])&0x00FF);
    
    if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for ArrDump Packet ");
    /*if (subCRC != readCRC) {
        logger->error("WRONG CRC FOR ArrDump PACKET. processed anyway for CPU debugging");
    }*/

    ArrDumpRecord* rec;
    ArrDump->PARAMETER_STAMP = (((UINT32)subData[0]<<24)&0xFF000000) + (((UINT32)subData[1]<<16)&0x00FF0000) +  (((UINT32)subData[2]<<8)&0x0000FF00) + (((UINT32)subData[3])&0x000000FF);
    long int offset = 4;
    int i = 0;
    ArrDump->Records->Clear();
    TClonesArray &recs = *(ArrDump->Records);
    while (offset < dataLength){
        rec = new(recs[i++]) ArrDumpRecord(); //add a new TmtcRecord
        rec->Arr_ID  = ((UINT8)subData[offset])&0xFF;
        rec->Arr_len = (((UINT16)subData[offset+1]<<8)&0xFF00) + ((UINT16)subData[offset+2])&0x00FF;
        rec->Data  = new TArrayI((int)rec->Arr_len, (int*)(subData+offset+3));
        offset = offset + sizeof(UINT32)*(rec->Arr_len) + 3;
    }
  }
