
// Implementation of the CalibTrailerReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/CalibTrailerEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibTrk1Reader"));

/**
 * Constructor. 
 */
CalibTrailerReader::CalibTrailerReader(void): 
  TechmodelAlgorithm(PacketType::CalibTrailer, "TechmodelCalibTrailerReader") { 
  logger->debug(_T("Constructor"));
  calibTrailer = new CalibTrailerEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTrailerReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalibTrailerReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTrailerReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calibTrailer, calibTrailer->Class());
}

/**
 * Unpack the CalibTrailer event from an input file.
 */
void CalibTrailerReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

