/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/TabDumpReader.cpp,v $
 * $Id: TabDumpReader.cpp,v 3.1 2005/03/06 04:29:20 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the TabDumpReader class.
 */

#include <string>
#include <log4cxx/logger.h>
#include <fstream>
#include "stdio.h"
extern "C" {
    #include "CRC.h"
}
#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TabDumpReader"));

/**
 * Constructor. 
 */
TabDumpReader::TabDumpReader(void): 
  TechmodelAlgorithm(PacketType::TabDump, "TechmodelTabDump") { 
  TabDump = new TabDumpEvent();
  logger->debug(_T("Constructor"));
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TabDumpReader::GetVersionInfo(void) const {
  return "$Header: /home/cvsmanager/yoda/techmodel/TabDumpReader.cpp,v 3.1 2005/03/06 04:29:20 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TabDumpReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &TabDump, TabDump->Class());
}

/**
 * Unpack the TabDump event from an input file.
 */
void TabDumpReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
  
    char      subData[length];
    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  dataLength = length - 2; //the block of data
  
    InputFile->read(subData, sizeof(subData));
    subCRC  = CM_Compute_CRC16(0, (UINT8*)subData, dataLength);
    readCRC = (((UINT16)(subData[length - 2]<<8))&0xFF00) + (((UINT16)subData[length - 1])&0x00FF);
    
    //if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for TabDump Packet ");
    if (subCRC != readCRC) {
        logger->error("WRONG CRC FOR TabDump PACKET. Processed anyway for CPU debugging");
    }

    TabDumpRecord* rec;
    TabDump->PARAMETER_STAMP = (((UINT32)subData[0]<<24)&0xFF000000) + (((UINT32)subData[1]<<16)&0x00FF0000) +  (((UINT32)subData[2]<<8)&0x0000FF00) + (((UINT32)subData[3])&0x000000FF);
    long int offset = 4;
    int i = 0;
    TabDump->Records->Clear();
    TClonesArray &recs = *(TabDump->Records);
    while (offset < dataLength){
        rec = new(recs[i++]) TabDumpRecord(); //add a new TabDump
        rec->Tab_ID  = ((UINT8)subData[offset])&0xFF;
        rec->Nrow = ((UINT8)subData[offset+1])&0xFF;
        rec->Ncol = ((UINT8)subData[offset+2])&0xFF;
        rec->Data = new TArrayI((int)((rec->Nrow)*(rec->Ncol)), (int*)(subData+offset+3));
        offset = offset + sizeof(UINT32)*(rec->Nrow)*(rec->Ncol) + 3;
    }
}
