
// Implementation of the TrgInitReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/TrgInitEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TrgInitReader"));

/**
 * Constructor. 
 */
TrgInitReader::TrgInitReader(void): 
  TechmodelAlgorithm(PacketType::TrgInit, "TechmodelTrgInitReader") { 
  logger->debug(_T("Constructor"));
  trgInit = new TrgInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TrgInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TrgInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TrgInitReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &trgInit, trgInit->Class());
}

/**
 * Unpack the TrgInit event from an input file.
 */
void TrgInitReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

