/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/CalibTrdReader.cpp,v $
 * $Id: CalibTrdReader.cpp,v 3.0 2005/03/04 15:54:11 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/CalibTrdEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibTrdReader"));

/**
 * Constructor. 
 */
CalibTrdReader::CalibTrdReader(void): 
  TechmodelAlgorithm(PacketType::CalibTrd, "TechmodelCalibTrdReader") { 
  logger->debug(_T("Constructor"));
  calibTrd = new CalibTrdEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTrdReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/CalibTrdReader.cpp,v 3.0 2005/03/04 15:54:11 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTrdReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calibTrd, calibTrd->Class());
}

/**
 * Unpack the CalibTrd event from an input file.
 */
void CalibTrdReader::RunEvent(int EventNumber, long int length) throw (Exception){
    
    
}

