
// Implementation of the CalInitReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/CalInitEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalInitReader"));

/**
 * Constructor. 
 */
CalInitReader::CalInitReader(void): 
  TechmodelAlgorithm(PacketType::CalInit, "TechmodelCalInitReader") { 
  logger->debug(_T("Constructor"));
  calInit = new CalInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalInitReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calInit, calInit->Class());
}

/**
 * Unpack the CalInit event from an input file.
 */
void CalInitReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

