
// Implementation of the CalAlarmReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalAlarmReader"));

/**
 * Constructor. 
 */
CalAlarmReader::CalAlarmReader(void): 
  TechmodelAlgorithm(PacketType::CalAlarm, "TechmodelCalAlarmReader") { 
  logger->debug(_T("Constructor"));
  calAlarm = new CalAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalAlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &calAlarm, calAlarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the CalAlarm event from an input file.
 */
void CalAlarmReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

