
// Implementation of the Ac1InitReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
    #include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"


using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.Ac1InitReader"));

/**
 * Constructor. 
 */
Ac1InitReader::Ac1InitReader(void): 
  TechmodelAlgorithm(PacketType::Ac1Init, "Ac1InitReader") { 
  logger->debug(_T("Constructor"));
  ac1Init = new Ac1InitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string Ac1InitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/Ac1InitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void Ac1InitReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &ac1Init, ac1Init->Class());
}

/**
 * Unpack the Ac1Init event from an input file.
 */
void Ac1InitReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

