/** @file
 * $Author: kusanagi $
 * $Date: 2005/03/04 15:54:11 $
 * $Revision: 3.0 $
 * 
 * Header file for the algorithms used to read the techmodel neutronDetector events.
 */

#ifndef NEUTRONDETECTOR_READER_H
#define NEUTRONDETECTOR_READER_H

#include "techmodel/TechmodelAlgorithm.h"
#include "event/PamelaRun.h"
#include "event/physics/neutronDetector/NeutronEvent.h"


namespace pamela {
  namespace neutron {
    /**
     * Algorithm to read techmodel neutron physics events.
     */
    class NeutronDetectorReader: public pamela::techmodel::TechmodelAlgorithm {
    private:
      /**
       * The physics event that is created in this algorithm.
       */
      NeutronEvent *neutronEvent;
      bool haveData(const char[], long int);
    public:
      NeutronDetectorReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int);
      virtual void RunEvent(int, const char[] , long int);
      virtual std::string GetVersionInfo(void) const;
    };
  }
}

#endif /* NEUTRONDETECTOR_READER_H */
