
// Implementation of the TofInitReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/TofInitEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TofInitReader"));

/**
 * Constructor. 
 */
TofInitReader::TofInitReader(void): 
  TechmodelAlgorithm(PacketType::TofInit, "TechmodelTofInitReader") { 
  logger->debug(_T("Constructor"));
  tofInit = new TofInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TofInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TofInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TofInitReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &tofInit, tofInit->Class());
}

/**
 * Unpack the TofInit event from an input file.
 */
void TofInitReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

