/** @file
 * $Author: kusanagi $
 * $Date: 2005/03/04 15:54:11 $
 * $Revision: 3.0 $
 * 
 * Header file for the algorithms used to read the techmodel data file.
 */

#ifndef READER_ALGORITHM_H
#define READER_ALGORITHM_H

#include "TechmodelAlgorithm.h"
#include "PscuEvent.h"


#include "endrun/PhysEndRunEvent.h"
#include "CalibCalPulse1Event.h"
#include "CalibCalPulse2Event.h"
#include "physics/TrackerReader.h"
#include "physics/AnticounterReader.h"
#include "physics/CalorimeterReader.h"
#include "physics/NeutronDetectorReader.h"
#include "physics/S4Reader.h"
#include "physics/TofReader.h"
#include "physics/TriggerReader.h"
#include "CalibTrkBothEvent.h"
#include "CalibTrk1Event.h"
#include "CalibTrk2Event.h"
#include "CalibTrdEvent.h"
#include "CalibTofEvent.h"
#include "CalibS4Event.h"
#include "CalibCalPedEvent.h"
#include "Calib1_Ac1Event.h"
#include "Calib1_Ac2Event.h"
#include "Calib2_Ac1Event.h"
#include "Calib2_Ac2Event.h"
#include "RunHeaderEvent.h"
#include "RunTrailerEvent.h"
#include "CalibHeaderEvent.h"
#include "CalibTrailerEvent.h"
#include "InitHeaderEvent.h"
#include "InitTrailerEvent.h"
#include "EventTrkEvent.h"
#include "TestTrkEvent.h"
#include "TestTofEvent.h"
#include "log/LogEvent.h"
#include "varDump/VarDumpEvent.h"
#include "arrDump/ArrDumpEvent.h"
#include "tabDump/TabDumpEvent.h"
#include "tsbt/TsbTEvent.h"
#include "tsbb/TsbBEvent.h"
#include "tmtc/TmtcEvent.h"
#include "mcmd/McmdEvent.h"
#include "ForcedFECmdEvent.h"
#include "Ac1InitEvent.h"
#include "CalInitEvent.h"
#include "TrkInitEvent.h"
#include "TofInitEvent.h"
#include "TrgInitEvent.h"
#include "NdInitEvent.h"
#include "S4InitEvent.h"
#include "Ac2InitEvent.h"
#include "CalAlarmEvent.h"
#include "AcAlarmEvent.h"
#include "TrkAlarmEvent.h"
#include "TrgAlarmEvent.h"
#include "TofAlarmEvent.h"
#include "S4AlarmEvent.h"

using namespace std;

namespace pamela {
  namespace techmodel {

/**********************************************
* Event reader algorithm for PhysEndRun events.
**********************************************/
    class PhysEndRunReader: public TechmodelAlgorithm {
    private:
      /** The PhysEndRun event that is created in the reader. */
      PhysEndRunEvent* physEndRun;
    public:
      PhysEndRunReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      //this type of RUNEvent should be the future develop. 
      //Pass the buffer not the pointer to file
      //virtual void RunEvent(int, long int, char[]);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibCalPulse1 events.
**********************************************/
    class CalibCalPulse1Reader: public TechmodelAlgorithm {
    private:
      /** The CalibCalPulse1 event that is created in the reader. */
      CalibCalPulse1Event* calibCalPulse1;
    public:
      CalibCalPulse1Reader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      //this type of RUNEvent should be the future develop. 
      //Pass the buffer not the pointer to file
      //virtual void RunEvent(int, long int, char[]);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibCalPulse2 events.
**********************************************/
    class CalibCalPulse2Reader: public TechmodelAlgorithm {
    private:
      /** The CalibCalPulse2 event that is created in the reader. */
      CalibCalPulse2Event* calibCalPulse2;
    public:
      CalibCalPulse2Reader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      //this type of RUNEvent should be the future develop. 
      //Pass the buffer not the pointer to file
      //virtual void RunEvent(int, long int, char[]);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for physics events.
**********************************************/
    class PhysicsReader: public TechmodelAlgorithm {
    private:
      /** The reader for tracker physics events. */
      tracker::TrackerReader*           trackerReader;
      anticounter::AnticounterReader*   anticounterReader;
      calorimeter::CalorimeterReader*   calorimeterReader;
      neutron::NeutronDetectorReader*   neutronReader;
      S4::S4Reader*                     s4Reader;
      tof::TofReader*                   tofReader;
      trigger::TriggerReader*           triggerReader;
    public:
      PhysicsReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibTrkBoth events.
**********************************************/
    class CalibTrkBothReader: public TechmodelAlgorithm {
    private:
      /** The CalibTrkBoth event that is created in the reader. */
      CalibTrkBothEvent* calibTrkBoth;
    public:
      CalibTrkBothReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      //this type of RUNEvent should be the future develop. 
      //Pass the buffer not the pointer to file
      //virtual void RunEvent(int, long int, char[]);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibTrk1 events.
**********************************************/
    class CalibTrk1Reader: public TechmodelAlgorithm {
    private:
      /** The CalibTrk1 event that is created in the reader. */
      CalibTrk1Event* calibTrk1;
    public:
      CalibTrk1Reader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      //this type of RUNEvent should be the future develop. 
      //Pass the buffer not the pointer to file
      //virtual void RunEvent(int, long int, char[]);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibTrk2 events.
**********************************************/
    class CalibTrk2Reader: public TechmodelAlgorithm {
    private:
      /** The CalibTrk2 event that is created in the reader. */
      CalibTrk2Event* calibTrk2;
    public:
      CalibTrk2Reader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibTrd events.
**********************************************/
    class CalibTrdReader: public TechmodelAlgorithm {
    private:
      /** The CalibTrd event that is created in the reader. */
      CalibTrdEvent* calibTrd;
    public:
      CalibTrdReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibTof events.
**********************************************/
    class CalibTofReader: public TechmodelAlgorithm {
    private:
      /** The CalibTof event that is created in the reader. */
      CalibTofEvent* CalibTof;
    public:
      CalibTofReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibS4 events.
**********************************************/
    class CalibS4Reader: public TechmodelAlgorithm {
    private:
      /** The CalibCal event that is created in the reader. */
      CalibS4Event* calibS4;
    public:
      CalibS4Reader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibCalPed events.
**********************************************/
    class CalibCalPedReader: public TechmodelAlgorithm {
    private:
      /** The CalibCalPed event that is created in the reader. */
      CalibCalPedEvent* calibCalPed;
    public:
      CalibCalPedReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };


/***********************************************
* Event reader algorithm for Calib1_Ac1 events.
**********************************************/
    class Calib1_Ac1Reader: public TechmodelAlgorithm {
    private:
      /** The CalibAc event that is created in the reader. */
      Calib1_Ac1Event* calib1_Ac1;
    public:
      Calib1_Ac1Reader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };


/***********************************************
* Event reader algorithm for Calib1_Ac2 events.
**********************************************/
    class Calib1_Ac2Reader: public TechmodelAlgorithm {
    private:
      /** The Calib1_Ac2 event that is created in the reader. */
      Calib1_Ac2Event* calib1_Ac2;
    public:
      Calib1_Ac2Reader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };

/***********************************************
* Event reader algorithm for Calib2_Ac1 events.
**********************************************/
    class Calib2_Ac1Reader: public TechmodelAlgorithm {
    private:
      /** The Calib2_Ac1 event that is created in the reader. */
      Calib2_Ac1Event* calib2_Ac1;
    public:
      Calib2_Ac1Reader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };

/***********************************************
* Event reader algorithm for Calib2_Ac2 events.
**********************************************/
    class Calib2_Ac2Reader: public TechmodelAlgorithm {
    private:
      /** The Calib2_Ac2 event that is created in the reader. */
      Calib2_Ac2Event* calib2_Ac2;
    public:
      Calib2_Ac2Reader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for RunHeader events.
**********************************************/
    class RunHeaderReader: public TechmodelAlgorithm {
    private:
      /** The RunHeader event that is created in the reader. */
      RunHeaderEvent* RunHeader;
    public:
      RunHeaderReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for RunTrailer events.
**********************************************/
    class RunTrailerReader: public TechmodelAlgorithm {
    private:
      /** The RunTrailer event that is created in the reader. */
      RunTrailerEvent* RunTrailer;
    public:
      RunTrailerReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibHeader events.
**********************************************/
    class CalibHeaderReader: public TechmodelAlgorithm {
    private:
      /** The CalibHeader event that is created in the reader. */
      CalibHeaderEvent* calibHeader;
    public:
      CalibHeaderReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalibTrailer events.
**********************************************/
    class CalibTrailerReader: public TechmodelAlgorithm {
    private:
      /** The CalibTrailer event that is created in the reader. */
      CalibTrailerEvent* calibTrailer;
    public:
      CalibTrailerReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for InitHeader events.
**********************************************/
    class InitHeaderReader: public TechmodelAlgorithm {
    private:
      /** The InitHeader event that is created in the reader. */
      InitHeaderEvent* initHeader;
    public:
      InitHeaderReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for InitTrailer events.
**********************************************/
    class InitTrailerReader: public TechmodelAlgorithm {
    private:
      /** The InitTrailer event that is created in the reader. */
      InitTrailerEvent* initTrailer;
    public:
      InitTrailerReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for EventTrk events.
**********************************************/
    class EventTrkReader: public TechmodelAlgorithm {
    private:
      /** The EventTrk event that is created in the reader. */
      EventTrkEvent* eventTrk;
    public:
      EventTrkReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for TestTrk events.
**********************************************/
    class TestTrkReader: public TechmodelAlgorithm {
    private:
      /** The TestTrk event that is created in the reader. */
      TestTrkEvent* testTrk;
    public:
      TestTrkReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for TestTof events.
**********************************************/
    class TestTofReader: public TechmodelAlgorithm {
    private:
      /** The TestTof event that is created in the reader. */
      TestTofEvent* testTof;
    public:
      TestTofReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (Exception);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for Log events.
**********************************************/
    class LogReader: public TechmodelAlgorithm {
    private:
      /** The Log event that is created in the reader. */
      LogEvent* Log;
    public:
      LogReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/***********************************************
* Event reader algorithm for VarDump events.
**********************************************/
    class VarDumpReader: public TechmodelAlgorithm {
    private:
      /** The VarDump event that is created in the reader. */
      VarDumpEvent* VarDump;
    public:
      VarDumpReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for ArrDump events.
**********************************************/
    class ArrDumpReader: public TechmodelAlgorithm {
    private:
      /** The ArrDump event that is created in the reader. */
      ArrDumpEvent* ArrDump;
    public:
      ArrDumpReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for TabDump events.
**********************************************/
    class TabDumpReader: public TechmodelAlgorithm {
    private:
      /** The TabDump event that is created in the reader. */
      TabDumpEvent* TabDump;
    public:
      TabDumpReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for TMTC events.
**********************************************/
    class TmtcReader: public TechmodelAlgorithm {
    //Length in bytes of the subPacket (that is te TmtcRecord excluded subCRC)
    static const int TMTC_SUB_LENGTH = 36;
    //Length in bytes of the subPacketCRC
    static const int TMTC_SUBCRC_LENGTH = 1;
    //Length in bytes of the PacketCRC
    static const int TMTC_CRC_LENGTH = 2;
    private:
      /** The TMTC event that is created in the reader. */
      TmtcEvent* Tmtc;
      //float convert_th(int);
    public:
    TmtcReader(void);
    virtual void Init(PamelaRun *);
    virtual void RunEvent(int, long int) throw (WrongCRCException);
    virtual string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for Mcmd events.
**********************************************/
    class McmdReader: public TechmodelAlgorithm {
    private:
      /** The Mcmd event that is created in the reader. */
      McmdEvent* Mcmd;
    public:
      McmdReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for ForcedFECmd events.
**********************************************/
    class ForcedFECmdReader: public TechmodelAlgorithm {
    private:
      /** The ForcedFECmd event that is created in the reader. */
      ForcedFECmdEvent* forcedFECmd;
    public:
      ForcedFECmdReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for Ac1Init events.
**********************************************/
    class Ac1InitReader: public TechmodelAlgorithm {
    private:
      /** The Ac1Init event that is created in the reader. */
      Ac1InitEvent* ac1Init;
    public:
      Ac1InitReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalInit events.
**********************************************/
    class CalInitReader: public TechmodelAlgorithm {
    private:
      /** The CalInit event that is created in the reader. */
      CalInitEvent* calInit;
    public:
      CalInitReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for TrkInit events.
**********************************************/
    class TrkInitReader: public TechmodelAlgorithm {
    private:
      /** The TrkInit event that is created in the reader. */
      TrkInitEvent* trkInit;
    public:
      TrkInitReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for TofInit events.
**********************************************/
    class TofInitReader: public TechmodelAlgorithm {
    private:
      /** The TofInit event that is created in the reader. */
      TofInitEvent* tofInit;
    public:
      TofInitReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for TrgInit events.
**********************************************/
    class TrgInitReader: public TechmodelAlgorithm {
    private:
      /** The TrgInit event that is created in the reader. */
      TrgInitEvent* trgInit;
    public:
      TrgInitReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for NdInit events.
**********************************************/
    class NdInitReader: public TechmodelAlgorithm {
    private:
      /** The NdInit event that is created in the reader. */
      NdInitEvent* ndInit;
    public:
      NdInitReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for S4Init events.
**********************************************/
    class S4InitReader: public TechmodelAlgorithm {
    private:
      /** The S4Init event that is created in the reader. */
      S4InitEvent* s4Init;
    public:
      S4InitReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for Ac2Init events.
**********************************************/
    class Ac2InitReader: public TechmodelAlgorithm {
    private:
      /** The Ac2Init event that is created in the reader. */
      Ac2InitEvent* ac2Init;
    public:
      Ac2InitReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


/**********************************************
* Event reader algorithm for CalAlarm events.
**********************************************/
    class CalAlarmReader: public TechmodelAlgorithm {
    private:
      /** The CalAlarm event that is created in the reader. */
      CalAlarmEvent* calAlarm;
    public:
      CalAlarmReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for AcAlarm events.
**********************************************/
    class AcAlarmReader: public TechmodelAlgorithm {
    private:
      /** The AcAlarm event that is created in the reader. */
      AcAlarmEvent* acAlarm;
    public:
      AcAlarmReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for TrkAlarm events.
**********************************************/
    class TrkAlarmReader: public TechmodelAlgorithm {
    private:
      /** The TrkAlarm event that is created in the reader. */
      TrkAlarmEvent* trkAlarm;
    public:
      TrkAlarmReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for TrgAlarm events.
**********************************************/
    class TrgAlarmReader: public TechmodelAlgorithm {
    private:
      /** The TrgAlarm event that is created in the reader. */
      TrgAlarmEvent* trgAlarm;
    public:
      TrgAlarmReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for TofAlarm events.
**********************************************/
    class TofAlarmReader: public TechmodelAlgorithm {
    private:
      /** The TofAlarm event that is created in the reader. */
      TofAlarmEvent* tofAlarm;
    public:
      TofAlarmReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for S4Alarm events.
**********************************************/
    class S4AlarmReader: public TechmodelAlgorithm {
    private:
      /** The S4Alarm event that is created in the reader. */
      S4AlarmEvent* s4Alarm;
    public:
      S4AlarmReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for TsbT events.
**********************************************/
    class TsbTReader: public TechmodelAlgorithm {
    private:
      /** The TsbT event that is created in the reader. */
      TsbTEvent* TsbT;
    public:
      TsbTReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for TsbB events.
**********************************************/
    class TsbBReader: public TechmodelAlgorithm {
    private:
      /** The TsbB event that is created in the reader. */
      TsbBEvent* TsbB;
    public:
      TsbBReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };

/**********************************************
* Event reader algorithm for PSCU events.
**********************************************/
    class PscuReader: public TechmodelAlgorithm {
    private:
      /** The PSCU event that is created in the reader. */
      PscuEvent* Pscu;
    public:
      PscuReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int, long int) throw (WrongCRCException);
      virtual std::string GetVersionInfo(void) const;
    };


  }
}

#endif /* READER_ALGORITHM_H */




