
// Implementation of the ForcedFECmdReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/ForcedFECmdEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.ForcedFECmdReader"));

/**
 * Constructor. 
 */
ForcedFECmdReader::ForcedFECmdReader(void): 
  TechmodelAlgorithm(PacketType::ForcedFECmd, "TechmodelForcedFECmdReader") { 
  logger->debug(_T("Constructor"));
  forcedFECmd = new ForcedFECmdEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string ForcedFECmdReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/ForcedFECmdReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void ForcedFECmdReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &forcedFECmd, forcedFECmd->Class());
}

/**
 * Unpack the ForcedFECmd event from an input file.
 */
void ForcedFECmdReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

